<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">

                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="../inicio/inicio.php"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">Productos</li>
                        </ol>
                    </nav>

                    <div class="card">
                        <div class="card-body text-center bg-gradient-royal">
                            <h3><b class="text-white">PRODUCTOS</b></h3>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-xl-12 mx-auto">
                            <div class="card">
                                <div class="card-body">
                                    <h6 class="mb-0 text-uppercase">Nuevo Producto</h6>
                                    <hr/>
                                    <div class="p-4 border rounded">
                                        <form method="POST" action="script/producto-guardar.php" class="row g-3 needs-validation" >
                                            <input type="text" required="" name="nombre_usuario" value="<?php echo $rowusu['nombre']; ?>" hidden>

                                            <div class="col-md-2">
                                                <label class="form-label" for="validationCustom02">Segmento</label>
                                                <select class="single-select3 " id="single-select3" required="" name="referencia_segmento" autofocus="">
                                                    <option selected="" disabled="" value="">Seleccione</option>

                                                    <?php
                                                    $sql6 = "SELECT * FROM segmento";
                                                    $query6 = $conn->query($sql6);
                                                    if ($query6->num_rows > 0) {
                                                        while ($row6 = $query6->fetch_assoc()) {
                                                            ?>
                                                            <option value="<?php echo $row6['referencia'] ?>"><?php echo $row6['referencia'] ?></option>
                                                            <?php
                                                        }
                                                    }
                                                    ?>
                                                </select>
                                                <div class="valid-feedback">Se ve bien!</div>
                                                <div class="invalid-feedback">Por favor, Digite un codigo.</div>
                                            </div> 
                                            <div class="col-md-2">
                                                <label class="form-label" for="validationCustom02">Codigo</label>
                                                <input class="form-control" id="validationCustom02" type="text" required="" name="codigo" >
                                                <div class="valid-feedback">Se ve bien!</div>
                                                <div class="invalid-feedback">Por favor, Digite un codigo.</div>
                                            </div>                                            
                                            <div class="col-md-4">
                                                <label class="form-label" for="validationCustom02">Referencia</label>
                                                <input class="form-control" id="validationCustom02" type="text" required="" name="referencia">
                                                <div class="valid-feedback">Se ve bien!</div>
                                                <div class="invalid-feedback">Por favor, Digite una referencia.</div>
                                            </div>
                                            <div class="col-md-2">
                                                <label class="form-label" for="validationCustom01">Color 1</label>
                                                <select class="single-select " id="single-select" required="" name="color">
                                                    <option selected="" disabled="" value="">Seleccione</option>
                                                    <?php
                                                    $sql2 = "SELECT * FROM color";
                                                    $query2 = $conn->query($sql2);
                                                    if ($query2->num_rows > 0) {
                                                        while ($row2 = $query2->fetch_assoc()) {
                                                            ?>
                                                            <option value="<?php echo $row2['color'] ?>"><?php echo $row2['color'] ?></option>
                                                            <?php
                                                        }
                                                    }
                                                    ?>
                                                </select>
                                                <div class="valid-feedback">Se ve bien!</div>
                                                <div class="invalid-feedback">Por favor, seleccione una categoria.</div>
                                            </div>

                                            <div class="col-md-2">
                                                <label class="form-label" for="validationCustom01">Color 2</label>
                                                <select class="single-select " id="single-select4" required="" name="color2">
                                                    <option selected="" disabled="" value="">Seleccione</option>
                                                    <?php
                                                    $sql21 = "SELECT * FROM color";
                                                    $query21 = $conn->query($sql21);
                                                    if ($query21->num_rows > 0) {
                                                        while ($row21 = $query21->fetch_assoc()) {
                                                            ?>
                                                            <option value="<?php echo $row21['color'] ?>"><?php echo $row21['color'] ?></option>
                                                            <?php
                                                        }
                                                    }
                                                    ?>
                                                </select>
                                                <div class="valid-feedback">Se ve bien!</div>
                                                <div class="invalid-feedback">Por favor, seleccione una categoria.</div>
                                            </div>

                                            <div class="col-md-4">
                                                <label class="form-label" for="validationCustom01">Categoria</label>
                                                <select class="single-select1  " id="single-select1" required="" name="categoria">
                                                    <option selected="" disabled="" value="">Seleccione</option>
                                                    <?php
                                                    $sql3 = "SELECT * FROM categoria_producto";
                                                    $query3 = $conn->query($sql3);
                                                    if ($query3->num_rows > 0) {
                                                        while ($row3 = $query3->fetch_assoc()) {
                                                            ?>
                                                            <option value="<?php echo $row3['categoria'] ?>"><?php echo $row3['categoria'] ?></option>
                                                            <?php
                                                        }
                                                    }
                                                    ?>
                                                </select>
                                                <div class="valid-feedback">Se ve bien!</div>
                                                <div class="invalid-feedback">Por favor, seleccione una categoria.</div>
                                                <div class="col-sm-9">
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <label class="form-label" for="validationCustom01">Clase</label>
                                                <select class="single-select2" id="single-select2" required="" name="clase">
                                                    <option selected="" disabled="" value="">Seleccione</option>
                                                    <?php
                                                    $sql6c = "SELECT * FROM clase";
                                                    $query6c = $conn->query($sql6c);
                                                    if ($query6c->num_rows > 0) {
                                                        while ($row6c = $query6c->fetch_assoc()) {
                                                            ?>

                                                            <option value="<?php echo $row6c['clase'] ?>"><?php echo $row6c['clase'] ?></option>
                                                            <?php
                                                        }
                                                    }
                                                    ?>
                                                </select>
                                                <div class="valid-feedback">Se ve bien!</div>
                                                <div class="invalid-feedback">Por favor, seleccione una clase.</div>
                                                <div class="col-sm-9">
                                                </div>
                                            </div>
                                            <div class="col-md-2">
                                                <label class="form-label" for="validationCustom02">Peso Grm.</label>
                                                <input class="form-control" id="validationCustom02" type="text" required="" name="peso">
                                                <div class="valid-feedback">Se ve bien!</div>
                                                <div class="invalid-feedback">Por favor, Digite la informacio necesaria.</div>
                                            </div>
                                            <div class="col-md-2">
                                                <label class="form-label" for="validationCustom02">Precio venta</label>
                                                <input class="form-control" id="validationCustom02" type="text" required="" name="precio_venta">
                                                <div class="valid-feedback">Se ve bien!</div>
                                                <div class="invalid-feedback">Por favor, Digite la informacio necesaria.</div>
                                            </div>
                                            <div class="col-md-4 mb-3">
                                                <label class="form-label" for="validationCustom02">Descripcion</label>
                                                <textarea class="form-control" id="validationCustom02" type="text" required="" name="descripcion">No aplica</textarea>
                                                <div class="valid-feedback">Se ve bien!</div>
                                                <div class="invalid-feedback">Por favor, digite los metros por prenda.</div>
                                            </div>
                                            <div class="col-12 text-end">
                                                <button class="btn btn-success" type="submit">Guardar</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end page content-->
                    </div>
                    <!--end page content wrapper-->

                    <style>
                        #hover_enlace:hover{
                            color: purple;
                            border-radius: 10px; 
                            box-shadow: 0px 0px 10px 0px purple;
                        }

                    </style>

                    <?php
                    $sqlcon = "";
                    if (isset($_GET['filtro'])) {

                        $referencia = $_GET['referencia'];
                        $categoria = $_GET['categoria'];
                    } else {
                        $referencia = 'Todo';
                        $categoria = 'Todo';
                    }

                    if (isset($_GET['referencia'])) {
                        $referencia = $_GET['referencia'];
                    } else {
                        $referencia = 'Todo';
                    }

                    if (isset($_GET['categoria'])) {

                        if ($_GET['referencia'] == 'Todo') {
                            $categoria = $_GET['categoria'];
                        } else {
                            $categoria = 'Todo';
                        }
                    } else {
                        $categoria = 'Todo';
                    }


                    if ($referencia != 'Todo' and $categoria == 'Todo') {
                        $sqlcon = "WHERE referencia='" . $referencia . "'";
                    } elseif ($categoria != 'Todo' and $referencia == 'Todo') {
                        $sqlcon = "WHERE categoria='" . $categoria . "'";
                    } elseif ($categoria != 'Todo' and $referencia != 'Todo') {
                        $sqlcon = "WHERE referencia='" . $referencia . "' AND categoria='" . $categoria . "'";
                    } else {
                        $sqlcon = "";
                    }
                    ?>

                    <div class="card">
                        <div class="card-body">
                            <div class="p-4 border rounded">
                                <form method="GET" action="producto.php" class="  d-print-none">
                                    <div class="row" style="">
                                        <div class="col-6 col-sm-3">
                                            <div class="form-group">
                                                <label><strong>Referencia:</strong></label>
                                                <select class="single-select" name="referencia" required>

                                                    <?php
                                                    if ($referencia != 'Todo') {
                                                        ?>
                                                        <option value="<?php echo $referencia; ?>"><?php echo $referencia; ?></option>
                                                        <option value="" disabled=""></option>
                                                        <option value="Todo">Todos</option>
                                                        <?php
                                                    } else {
                                                        ?>
                                                        <option value="Todo">Todos</option>
                                                        <option value="" disabled=""></option>
                                                        <?php
                                                    }
                                                    ?>
                                                    <?php
                                                    $sqlp = "SELECT * FROM producto";
                                                    $queryp = $conn->query($sqlp);
                                                    if ($queryp->num_rows > 0) {
                                                        while ($rowp = $queryp->fetch_assoc()) {
                                                            ?>
                                                            <option value="<?php echo $rowp['referencia']; ?>"><?php echo $rowp['codigo']; ?> - <?php echo $rowp['referencia']; ?></option>

                                                            <?php
                                                        }
                                                    }
                                                    ?>

                                                </select>  
                                            </div>
                                        </div>
                                        <div class="col-6 col-sm-3">
                                            <div class="form-group">
                                                <label><strong>Categorias:</strong></label>
                                                <select class="single-select" name="categoria" required>

                                                    <?php
                                                    if ($categoria != 'Todo') {
                                                        ?>
                                                        <option value="<?php echo $categoria; ?>"><?php echo $categoria; ?></option>
                                                        <option value="" disabled=""></option>
                                                        <option value="Todo">Todos</option>
                                                        <?php
                                                    } else {
                                                        ?>
                                                        <option value="Todo">Todos</option>
                                                        <option value="" disabled=""></option>
                                                        <?php
                                                    }
                                                    ?>
                                                    <?php
                                                    $sqlc = "SELECT * FROM categoria_producto ORDER BY categoria asc";
                                                    $queryc = $conn->query($sqlc);
                                                    if ($queryc->num_rows > 0) {
                                                        while ($rowc = $queryc->fetch_assoc()) {
                                                            ?>
                                                            <option value="<?php echo $rowc['categoria']; ?>"><?php echo $rowc['categoria']; ?></option>
                                                            <?php
                                                        }
                                                    }
                                                    ?>

                                                </select>                         
                                            </div>
                                        </div>
                                        <div class="col-5 col-sm-1 pt-3">
                                            <div class="form-group">
                                                <button class="btn btn-primary px-4 radius-30" type="submit" name="filtro">
                                                    Filtrar
                                                </button>
                                            </div>
                                        </div>
                                        <div class="col-5 col-sm-1 pt-3">
                                            <div class="form-group">
                                                <a href="producto.php" class="btn btn-secondary px-2 radius-30" >
                                                    Restablecer
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>


                    <?php
                    $registro_por_pagina = 10;
                    $pagina = '';
                    if (isset($_GET["pagina"])) {
                        $pagina = $_GET["pagina"];
                    } else {
                        $pagina = 1;
                    }

                    $start_from = ($pagina - 1) * $registro_por_pagina;
                    ?>

                    <div class="card">
                        <div class="card-body">
                            <h6 class="mb-0 text-uppercase">Lista de productos</h6>
                            <hr/>
                           <div class=" mt-2" style="overflow: auto;">
                                <table class="table mb-0 table-striped table-bordered" border="1"  style="width: 100%;" >
                                    <thead class="">
                                        <tr class="bg-gradient-royal text-white">
                                            <th class=" ">FOTO</th>
                                            <th class="text-center ">SEGMENTO</th>
                                            <th class="text-center ">COD</th>
                                            <th class=" ">REFERENCIA</th>                                           
                                            <th class=" ">COLOR</th>
                                            <th class=" ">COLOR 2</th>
                                            <th class=" ">BICOLOR</th>
                                            <th class="text-center ">CATEGORIA</th>
                                            <th class="text-center ">CLASE</th>
                                            <th class="text-center ">PESO</th> 
                                            <th class="text-center ">HABILITADO</th>
                                            <th class="text-center ">PRECIO UNIDAD</th>
                                            <th class=" ">CANT.</th>
                                            <th class="text-center ">DETALLE</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $total_activo = 0;
                                        $sql4 = "SELECT * FROM producto $sqlcon ORDER BY referencia asc LIMIT $start_from, $registro_por_pagina";
                                        $query4 = $conn->query($sql4);
                                        if ($query4->num_rows > 0) {
                                            while ($row4 = $query4->fetch_assoc()) {

                                                $sql5 = "SELECT * FROM color WHERE color='" . $row4['color'] . "'";
                                                $query5 = $conn->query($sql5);
                                                $row5 = $query5->fetch_assoc();

                                                $sql51 = "SELECT * FROM color WHERE color='" . $row4['color2'] . "'";
                                                $query51 = $conn->query($sql51);
                                                $row51 = $query51->fetch_assoc();

                                                
                                                ?>
                                                <tr class="align-middle" id="hover_enlace">
                                                    <td>
                                                        <div class="d-flex align-items-center gap-3">
                                                            <div class="product-box border">
                                                                <?php
                                                                if ($row4['foto1'] == 'NO APLICA') {
                                                                    ?>
                                                                    <img src="../../img/camara.jpg" alt="" style="object-fit: contain; width:100%; height:100%;">
                                                                    <?php
                                                                } else {
                                                                    ?>
                                                                    <img src="../../img-producto/<?php echo $row4['foto1']; ?>" alt="" style="object-fit: contain; width:100%; height:100%;">
                                                                    <?php
                                                                }
                                                                ?>
                                                            </div>
                                                            <div class="product-info">
                                                                <h6 class="product-name mb-1"></h6>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td class="text-center">
                                                        <b><?php echo $row4['referencia_segmento']; ?></b>
                                                    </td>
                                                    <td class="text-center">
                                                        <b><?php echo $row4['codigo']; ?></b>
                                                    </td>
                                                    <td>
                                                        <?php echo $row4['referencia']; ?>
                                                    </td>

                                                    <td class="">
                                                        <?php echo $row4['color']; ?> 
                                                        <?php
                                                        if ($row5['rgb'] == '') {
                                                            ?>
                                                            <i class="fa-solid fa-circle-info fa-2x float-end text-primary"></i>
                                                            <?php
                                                        } else {
                                                            ?>
                                                            <i class="fas fa-circle fa-2x float-end" style="color: <?php echo $row5['rgb']; ?>"></i>
                                                            <?php
                                                        }
                                                        ?>
                                                    </td> 

                                                    <td class="">
                                                        <?php echo $row4['color2']; ?> 
                                                        <?php
                                                        if ($row51['rgb'] == '') {
                                                            ?>
                                                            <i class="fa-solid fa-circle-info fa-2x float-end text-primary"></i>
                                                            <?php
                                                        } else {
                                                            ?>
                                                            <i class="fas fa-circle fa-2x float-end" style="color: <?php echo $row51['rgb']; ?>"></i>
                                                            <?php
                                                        }
                                                        ?>
                                                    </td> 
                                                    <td class="">
                                                        <?php echo $row4['bicolor']; ?>
                                                    </td>
                                                    <td class="">
                                                        <?php echo $row4['categoria']; ?>
                                                    </td>
                                                    <td class="">
                                                        <?php echo $row4['clase']; ?>
                                                    </td>
                                                    <td class="text-end">
                                                        <?php echo $row4['peso']; ?> g
                                                    </td>
                                                    <td class="text-center">
                                                        <?php
                                                        if ($row4['habilitado'] == 'Si') {
                                                            ?>
                                                            <span class="badge alert-success"><?php echo $row4['habilitado']; ?></span>
                                                            <?php
                                                        } else {
                                                            ?>
                                                            <span class="badge alert-danger"><?php echo $row4['habilitado']; ?></span>

                                                            <?php
                                                        }
                                                        ?>
                                                    </td>
                                                    <td class="text-center">
                                                        <b>$</b> <?php echo number_format($row4['precio_venta'], 0); ?>
                                                    </td>

                                                    <?php
                                                    $total_tallas1 = 0;
                                                    for ($i = 10; $i < 50; $i++) {

                                                        $sql1 = "SELECT SUM(cantidad) AS cantidad FROM talla_producto WHERE referencia_producto='" . $row4['referencia'] . "' AND talla='$i'";
                                                        $query1 = $conn->query($sql1);
                                                        $row1 = $query1->fetch_assoc();

                                                        $sql3 = "SELECT SUM(cantidad) AS cantidad_entrada FROM novedad WHERE referencia_producto='" . $row4['referencia'] . "' AND talla='$i' AND movimiento='Entrada' ";
                                                        $query3 = $conn->query($sql3);
                                                        $row3 = $query3->fetch_assoc();

                                                        $sql5 = "SELECT SUM(cantidad) AS produccion FROM produccion_detalle WHERE referencia_producto='" . $row4['referencia'] . "' AND talla='$i'";
                                                        $query5 = $conn->query($sql5);
                                                        $row5 = $query5->fetch_assoc();

                                                        $sql2 = "SELECT SUM(cantidad) AS cantidad_fuera FROM despacho_detalle WHERE referencia_producto='" . $row4['referencia'] . "' AND talla='$i' AND (estado='Proceso' OR estado='Confirmado' OR estado='Alistamiento' OR estado='Enviado' OR estado='Novedad' OR estado='Entregado' OR estado='Finalizado')";
                                                        $query2 = $conn->query($sql2);
                                                        $row2 = $query2->fetch_assoc();

                                                        $sql7 = "SELECT SUM(cantidad) AS cantidad_salida FROM novedad WHERE referencia_producto='" . $row4['referencia'] . "' AND talla='$i' AND movimiento='Salida' ";
                                                        $query7 = $conn->query($sql7);
                                                        $row7 = $query7->fetch_assoc();

                                                        $disponibilidad1 = ($row1['cantidad'] + $row3['cantidad_entrada'] + $row5['produccion']) - ($row2['cantidad_fuera'] + $row7['cantidad_salida']);

                                                        if ($disponibilidad1 > 0) {
                                                            $color_campo = 'text-success';
                                                            $texto = 'background-color: #bceed5';
                                                        } elseif ($disponibilidad1 < 0) {
                                                            $color_campo = 'text-danger';
                                                            $texto = 'background-color: #ffc5e6';
                                                        } else {
                                                            $color_campo = '';
                                                            $texto = '';
                                                        }

                                                        $total_tallas1 += $disponibilidad1;
                                                    }
                                                    ?>
                                                    <td class="text-center font-14"> <strong><?php echo $total_tallas1; ?></strong></td>


                                                    <td class="text-center">
                                                        <a href="kardex.php?referencia=<?php echo $row4['referencia']; ?>">
                                                            <i class="fas fa-file-alt fa-2x"></i>
                                                        </a>
                                                    </td>
                                                </tr>
                                                <?php
                                            }
                                        }
                                        ?>
                                    </tbody>

                                </table>
                            </div>
                        </div>
                    </div>






                    <?php
                    $sql2 = "SELECT * FROM producto $sqlcon ORDER BY referencia asc ";
                    $query2 = $conn->query($sql2);
                    $row2 = mysqli_num_rows($query2);

                    $total_pages = ceil($row2 / $registro_por_pagina);

                    $pagina_antes = $total_pages - 5;
                    ?>

                    <style>


                        .paginacion ul {
                            text-align: right;
                        }

                        .paginacion ul li {
                            display:inline-block;
                        }

                        .paginacion ul li a {
                            display:block;
                            padding:5px 15px;
                            color:purple;
                            background:#F2F2F2;
                            text-decoration: none;
                        }

                        .paginacion ul li a:hover {
                            background-color: purple;
                            color:#fff;
                        }

                        .paginacion ul li .active {
                            background:#purple;
                            font-weight:bold;
                        }
                    </style>





                    <section class="paginacion mt-3">
                        <ul class="" style="padding-left: 2px; padding-right: 2px;">
                            <?php
                            if ($pagina > 1) {
                                ?>
                                <li class="">
                                    <a class="page-link" href="producto.php?pagina=<?php echo ($pagina - 1); ?>&&referencia=<?php echo $referencia; ?>&&categoria=<?php echo $categoria; ?>" aria-label="Previous">
                                        <span aria-hidden="true"><</span>
                                    </a>
                                </li>
                                <?php
                            }

                            if ($total_pages <= 7) {
                                for ($i = 1; $i <= $total_pages; $i++) {

                                    if ($pagina == $i) {
                                        $color = "style='  background-color: purple; color:#fff;'";
                                    } else {
                                        $color = "";
                                    }
                                    ?>
                                    <li class=""><a class="page-link" href="producto.php?pagina=<?php echo $i; ?>&&referencia=<?php echo $referencia; ?>&&categoria=<?php echo $categoria; ?>" <?php echo$color; ?>><?php echo $i; ?></a></li>
                                    <?php
                                }
                            } else {

                                if ($pagina > 5 and $pagina <= $pagina_antes) {

                                    $datos_iz = $pagina - 2;
                                    $datos_der = $pagina + 2;
                                    ?>
                                    <li class=""><a class="page-link" href="producto.php?pagina=1&&referencia=<?php echo $referencia; ?>&&categoria=<?php echo $categoria; ?>">1</a></li>
                                    <li class=""><a class="page-link" href="" style="pointer-events: none;">...</a></li>
                                    <?php
                                    for ($i = $datos_iz; $i <= $datos_der; $i++) {

                                        if ($pagina == $i) {
                                            $color = "style='  background-color: purple; color:#fff;'";
                                        } else {
                                            $color = "";
                                        }
                                        ?>
                                        <li class=""><a class="page-link" href="producto.php?pagina=<?php echo $i; ?>&&referencia=<?php echo $referencia; ?>&&categoria=<?php echo $categoria; ?>" <?php echo$color; ?>><?php echo $i; ?></a></li>
                                        <?php
                                    }
                                    ?>
                                    <li class=""><a class="page-link" href="" style="pointer-events: none;">...</a></li>
                                    <li class=""><a class="page-link" href="producto.php?pagina=<?php echo $total_pages; ?>&&referencia=<?php echo $referencia; ?>&&categoria=<?php echo $categoria; ?>"><?php echo $total_pages; ?></a></li>

                                    <?php
                                } elseif ($pagina < 6) {

                                    for ($i = 1; $i <= 6; $i++) {

                                        if ($pagina == $i) {
                                            $color = "style='  background-color: purple; color:#fff;'";
                                        } else {
                                            $color = "";
                                        }
                                        ?>

                                        <li class=""><a class="page-link" href="producto.php?pagina=<?php echo $i; ?>&&referencia=<?php echo $referencia; ?>&&categoria=<?php echo $categoria; ?>" <?php echo $color; ?>><?php echo $i; ?></a></li>
                                        <?php
                                    }
                                    ?>
                                    <li class=""><a class="page-link" href="" style="pointer-events: none;">...</a></li>
                                    <li class=""><a class="page-link" href="producto.php?pagina=<?php echo $total_pages; ?>&&referencia=<?php echo $referencia; ?>&&categoria=<?php echo $categoria; ?>"><?php echo $total_pages; ?></a></li>

                                    <?php
                                } elseif ($pagina > $pagina_antes) {
                                    ?>
                                    <li class=""><a class="page-link" href="producto.php?pagina=1&&referencia=<?php echo $referencia; ?>&&categoria=<?php echo $categoria; ?>">1</a></li>
                                    <li class=""><a class="page-link" href="" style="pointer-events: none;">...</a></li>
                                    <?php
                                    for ($i = $pagina_antes; $i <= $total_pages; $i++) {
                                        if ($pagina == $i) {
                                            $color = "style='  background-color: purple; color:#fff;'";
                                        } else {
                                            $color = "";
                                        }
                                        ?>
                                        <li class=""><a class="page-link" href="producto.php?pagina=<?php echo $i; ?>&&referencia=<?php echo $referencia; ?>&&categoria=<?php echo $categoria; ?>" <?php echo $color; ?>><?php echo $i; ?></a></li>
                                        <?php
                                    }
                                }
                            }

                            if ($pagina < $total_pages) {
                                ?>
                                <li class="">
                                    <a class="page-link" href="producto.php?pagina=<?php echo ($pagina + 1); ?>&&referencia=<?php echo $referencia; ?>&&categoria=<?php echo $categoria; ?>" aria-label="Next">
                                        <span aria-hidden="true">></span>
                                    </a>
                                </li>
                                <?php
                            }
                            ?>

                        </ul>
                    </section>


                    <?php echo include '../general/footer.php'; ?>
                </div>
            </div>
        </div>
        <!--end wrapper-->
        <?php echo include '../general/libreria-js.php'; ?>

        <script>






            //Tabla producto
            $(document).ready(function () {
                var select = $('#single-select1').select2({
                    theme: 'bootstrap4',
                    width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
                    placeholder: $(this).data('placeholder'),
                    allowClear: Boolean($(this).data('allow-clear')),
                });


            });


            //Tabla producto
            $(document).ready(function () {
                var select2 = $('#single-select2').select2({
                    theme: 'bootstrap4',
                    width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
                    placeholder: $(this).data('placeholder'),
                    allowClear: Boolean($(this).data('allow-clear')),
                });


            });

            //Tabla producto
            $(document).ready(function () {
                var select3 = $('#single-select3').select2({
                    theme: 'bootstrap4',
                    width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
                    placeholder: $(this).data('placeholder'),
                    allowClear: Boolean($(this).data('allow-clear')),
                });


            });


            //Tabla producto
            $(document).ready(function () {
                var select3 = $('#single-select4').select2({
                    theme: 'bootstrap4',
                    width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
                    placeholder: $(this).data('placeholder'),
                    allowClear: Boolean($(this).data('allow-clear')),
                });


            });




            //Tabla producto
            $(document).ready(function () {
                var table = $('#example2').DataTable({
                    lengthChange: false,
                    buttons: ['copy', 'excel', 'pdf', 'print'],
                    "order": false,
                });

                table.buttons().container()
                        .appendTo('#example2_wrapper .col-md-6:eq(0)');
            });

        </script>

    </body>
</html>