<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';

if (isset($_GET['filtro'])) {
    $fecha_desde = $_GET['fecha_desde'];
    $fecha_hasta = $_GET['fecha_hasta'];
    $nombre_tercero = $_GET['nombre_tercero'];
} else {
    $fecha_desde = date("Y-m-d");
    $fecha_hasta = date("Y-m-d");
}
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <div class="container-fluid p-5 ">

            <div class="page-content">

                <nav aria-label="breadcrumb" class="d-print-none">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="../inicio/inicio.php"> 
                                <ion-icon name="home-outline"></ion-icon>
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">RPT - Kardex por cliente</li>
                    </ol>
                </nav>

                <div class="card d-print-none">
                    <div class="card-body text-center">
                        <h3><b> KARDEX POR CLIENTE</b></h3>
                    </div>
                </div>

                <div class="row d-print-none">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="p-2 border rounded ">
                                    <form method="GET" action="rpt-kardex.php" class=" d-print-none">
                                        <div class="row">
                                            <div class="col-6 col-sm-2 ">
                                                <div class="form-group">
                                                    <label>Desde</label>
                                                    <input type="date" class="form-control form-control-sm" name="fecha_desde" value="<?php echo $fecha_desde; ?>" required>  
                                                </div>
                                            </div>
                                            <div class="col-6 col-sm-2">
                                                <div class="form-group">
                                                    <label>Hasta</label>
                                                    <input type="date" class="form-control form-control-sm" name="fecha_hasta" value="<?php echo $fecha_hasta; ?>" required>  
                                                </div>
                                            </div>

                                            <div class="col-sm-5">
                                                <div class="form-group">
                                                    <label>TERCERO</label>
                                                    <select class="single-select form-control-sm" name="nombre_tercero" required autofocus="">

                                                        <?php
                                                        if (isset($_GET['filtro'])) {

                                                            if ($nombre_tercero != 'todo') {
                                                                ?>
                                                                <option value="<?php echo $nombre_tercero; ?>"><?php echo $nombre_tercero; ?></option>
                                                                <option value="" disabled="" >Seleccione</option>
                                                                <option value="TODO" >TODO</option>

                                                                <?php
                                                            } else {
                                                                ?>

                                                                <option value="" disabled="" selected="">Seleccione</option>
                                                                <option value="TODO" >TODO</option>
                                                                <?php
                                                            }
                                                        } else {
                                                            ?>
                                                            <option value="" disabled="" selected="">Seleccione</option>
                                                            <option value="TODO" >TODO</option>

                                                            <?php
                                                        }



                                                        $sql6m = "SELECT * FROM tercero";
                                                        $query6m = $conn->query($sql6m);
                                                        if ($query6m->num_rows > 0) {
                                                            while ($row6m = $query6m->fetch_assoc()) {
                                                                ?>
                                                                <option value="<?php echo $row6m['nombre'] ?>"><?php echo $row6m['nombre'] ?></option>
                                                                <?php
                                                            }
                                                        }
                                                        ?>
                                                    </select>  
                                                </div>
                                            </div>
                                            <div class="col-5 col-sm-1 pt-3">
                                                <div class="form-group">
                                                    <button class="btn btn-primary px-2 radius-30" type="submit" name="filtro" style="width: 100%;">
                                                        Consultar
                                                    </button>  
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>



                <div class="card ">
                    <div class="card-body">

                        <style>
                            th, td { white-space: nowrap; }

                            div.dataTables_wrapper {
                                width: 100%;
                                margin: 0 auto;
                            }


                        </style>

                        <?php
                        if (isset($_GET['filtro'])) {

                            $fecha_desde = $_GET['fecha_desde'];
                            $fecha_hasta = $_GET['fecha_hasta'];
                            $nombre_tercero = $_GET['nombre_tercero'];
                            ?>
                            <div class=" mt-3">
                                <div class="d-print-none">
                                    <div class="float-end">
                                        <a href="javascript:window.print()" class="btn btn-info waves-effect waves-light">
                                            <i class="fas fa-print"></i>
                                        </a>
                                    </div>
                                    <div class="clearfix"></div>
                                </div>


                                <?php
                                if ($nombre_tercero == 'TODO') {
                                    $nit = 'No aplica';
                                } else {
                                    $sqlter = "SELECT * FROM tercero WHERE nombre='$nombre_tercero'";
                                    $queryter = $conn->query($sqlter);
                                    $rowter = $queryter->fetch_assoc();

                                    $nit = $rowter['nit'];
                                }
                                ?>
                                <div class="p-2 rounded">
                                    <div class="row">
                                        <div class="col-sm-2 text-center">
                                            <img src="../../img/logo.png" class="logo-icon"  alt="logo icon" width="80">

                                        </div> 

                                        <div class="col-sm-8 text-start">
                                            <h6 class="text-dark mt-0 mb-1"><b>KARDEX POR CLIENTE</b></h6>

                                            <h6 class="text-dark mt-0 mb-1"><b> <?php echo $nombre_tercero; ?></b></h6>  
                                            <h6 class="text-dark mt-0 mb-1"><b>NIT: </b><?php echo $nit; ?></h6> 
                                            <h6 class="text-dark mt-0 mb-0">
                                                <?php echo strftime("%d - %B - %Y", strtotime($fecha_desde)); ?> 
                                                <b class="ms-3 me-3">|</b> 
                                                <?php echo strftime("%d - %B - %Y", strtotime($fecha_hasta)); ?>
                                            </h6> 

                                        </div>
                                    </div>
                                </div>

                                <style>
                                    #hover_enlace:hover{
                                        color: purple;
                                        border-radius: 10px; 
                                        box-shadow: 0px 0px 10px 0px purple;
                                    }



                                </style>


                                <?php
                                $sql = "SELECT pd.referencia_producto FROM pedido p, pedido_detalle pd WHERE p.id=pd.id_pedido AND p.fecha BETWEEN '" . $fecha_desde . "' AND '" . $fecha_hasta . "' AND p.nombre_tercero='$nombre_tercero' AND p.estado!='Cancelado'
                                        UNION 
                                        SELECT dd.referencia_producto FROM despacho d, despacho_detalle dd WHERE d.id=dd.id_despacho AND d.fecha BETWEEN '" . $fecha_desde . "' AND '" . $fecha_hasta . "' AND d.nombre_tercero='$nombre_tercero' AND d.estado!='Cancelado'";
                                $query = $conn->query($sql);
                                if ($query->num_rows > 0) {
                                    while ($row = $query->fetch_assoc()) {
                                        ?>
                                        <table class="table table-hover text-sm table-sm table-striped table-bordered mt-5 tabla-datatable" style="width: 100%;" id="">
                                            <thead>
                                                <tr class="bg-light-dark text-dark">
                                                    <th class=" p-1 " style="width: 7%;"  hidden="">ocultar</th>
                                                    <th class=" p-1 " style="width: 7%;"  >FECHA</th>
                                                    <th class="text-center p-1" style="width: 20%;"><?php echo $row['referencia_producto']; ?></th>
                                                    <th class="text-center" style="width: 7%;">NUMERO</th>

                                                    <?php
                                                    $sql1 = "SELECT pd.talla as talla FROM pedido p, pedido_detalle pd WHERE p.id=pd.id_pedido AND p.fecha BETWEEN '" . $fecha_desde . "' AND '" . $fecha_hasta . "' AND p.nombre_tercero='$nombre_tercero'  AND p.estado!='Cancelado'
                                                                UNION 
                                                                SELECT dd.talla as talla FROM despacho d, despacho_detalle dd WHERE d.id=dd.id_despacho AND d.fecha BETWEEN '" . $fecha_desde . "' AND '" . $fecha_hasta . "' AND d.nombre_tercero='$nombre_tercero'  AND d.estado!='Cancelado' ORDER BY talla asc";
                                                    $query1 = $conn->query($sql1);
                                                    if ($query1->num_rows > 0) {
                                                        while ($row1 = $query1->fetch_assoc()) {
                                                            ?>
                                                            <th class="text-center p-1"><?php echo $row1['talla']; ?></th>
                                                            <?php
                                                        }
                                                    }
                                                    ?>

                                                    <th class="text-center" style="width: 7%;">TOTAL</th>
                                                </tr>
                                            </thead>
                                            <tbody>

                                                <?php
                                                //PEDIDOS
                                                $sql2 = "SELECT p.fecha, p.numero_pedido, p.id as id, p.estado FROM pedido p, pedido_detalle pd WHERE p.id=pd.id_pedido AND p.fecha BETWEEN '" . $fecha_desde . "' AND '" . $fecha_hasta . "' AND p.nombre_tercero='$nombre_tercero' AND pd.referencia_producto='" . $row['referencia_producto'] . "'  AND p.estado!='Cancelado' GROUP BY p.id";
                                                $query2 = $conn->query($sql2);
                                                if ($query2->num_rows > 0) {
                                                    while ($row2 = $query2->fetch_assoc()) {
                                                        ?>
                                                        <tr class="align-middle">
                                                            <td hidden=""><?php echo $row2['fecha']; ?></td>
                                                            <td><?php echo date('d-m-Y', strtotime($row2['fecha'])); ?></td>
                                                            <td>
                                                                PEDIDO

                                                                <?php
                                                                if ($row2['estado'] == 'Proceso') {
                                                                    $alert_text = 'text-white';
                                                                    $alert = 'bg-info';
                                                                } elseif ($row2['estado'] == 'Confirmado') {
                                                                    $alert_text = 'text-white';
                                                                    $alert = 'bg-pink';
                                                                } elseif ($row2['estado'] == 'Recibido') {
                                                                    $alert_text = 'text-white';
                                                                    $alert = 'bg-success';
                                                                } elseif ($row2['estado'] == 'Cancelado') {
                                                                    $alert_text = 'text-white';
                                                                    $alert = 'bg-secondary';
                                                                } else {
                                                                    $text = 'text-dark';
                                                                }
                                                                ?>
                                                                <span class="float-end badge  <?php echo $alert; ?>"><?php echo $row2['estado']; ?></span>

                                                            </td>
                                                            <td class="text-center ">
                                                                <b>
                                                                    <a href="#" class="text-warning">
                                                                        <?php echo $row2['numero_pedido']; ?>
                                                                    </a>
                                                                </b>
                                                            </td>
                                                            <?php
                                                            $total_tallas = 0;
                                                            $sql1 = "SELECT pd.talla as talla FROM pedido p, pedido_detalle pd WHERE p.id=pd.id_pedido AND p.fecha BETWEEN '" . $fecha_desde . "' AND '" . $fecha_hasta . "' AND p.nombre_tercero='$nombre_tercero'  AND p.estado!='Cancelado'
                                                                UNION 
                                                                SELECT dd.talla as talla FROM despacho d, despacho_detalle dd WHERE d.id=dd.id_despacho AND d.fecha BETWEEN '" . $fecha_desde . "' AND '" . $fecha_hasta . "' AND d.nombre_tercero='$nombre_tercero' AND d.estado!='Cancelado' ORDER BY talla asc";
                                                            $query1 = $conn->query($sql1);
                                                            if ($query1->num_rows > 0) {
                                                                while ($row1 = $query1->fetch_assoc()) {


                                                                    $sql3 = "SELECT SUM(cantidad) as cantidad FROM pedido_detalle WHERE id_pedido='" . $row2['id'] . "' AND referencia_producto='" . $row['referencia_producto'] . "' AND talla='" . $row1['talla'] . "'";
                                                                    $query3 = $conn->query($sql3);
                                                                    $row3 = $query3->fetch_assoc();
                                                                    ?>
                                                                    <td class="text-center p-1"><?php echo $row3['cantidad']; ?></td>
                                                                    <?php
                                                                    $total_tallas += $row3['cantidad'];
                                                                }
                                                            }
                                                            ?>
                                                            <td class="text-end">
                                                                <b><?php echo number_format($total_tallas, 0); ?></b>
                                                            </td>
                                                        </tr>
                                                        <?php
                                                    }
                                                }
                                                ?>

                                                <?php
                                                //DESPACHOS
                                                $sql2d = "SELECT d.fecha, d.numero_despacho, d.id as id, d.estado FROM despacho d, despacho_detalle dd WHERE d.id=dd.id_despacho AND d.fecha BETWEEN '" . $fecha_desde . "' AND '" . $fecha_hasta . "' AND d.nombre_tercero='$nombre_tercero' AND dd.referencia_producto='" . $row['referencia_producto'] . "'  AND d.estado!='Cancelado' GROUP BY d.id";
                                                $query2d = $conn->query($sql2d);
                                                if ($query2d->num_rows > 0) {
                                                    while ($row2d = $query2d->fetch_assoc()) {
                                                        ?>
                                                        <tr class="align-middle">
                                                            <td hidden=""><?php echo $row2d['fecha']; ?></td>
                                                            <td><?php echo date('d-m-Y', strtotime($row2d['fecha'])); ?></td>
                                                            <td>DESPACHO


                                                                <?php
                                                                if ($row2d['estado'] == 'Proceso') {
                                                                    $alert_text = 'text-white';
                                                                    $alert = 'bg-info';
                                                                } elseif ($row2d['estado'] == 'Enviado') {
                                                                    $alert_text = 'text-white';
                                                                    $alert = 'bg-warning';
                                                                } elseif ($row2d['estado'] == 'Novedad') {
                                                                    $alert_text = 'text-white';
                                                                    $alert = 'bg-bronze';
                                                                } elseif ($row2d['estado'] == 'Recibido') {
                                                                    $alert_text = 'text-white';
                                                                    $alert = 'bg-success';
                                                                } elseif ($row2d['estado'] == 'Cancelado') {
                                                                    $alert_text = 'text-white';
                                                                    $alert = 'bg-secondary';
                                                                } else {
                                                                    $text = 'text-dark';
                                                                }
                                                                ?>
                                                                <span class="float-end badge <?php echo $alert; ?>"><?php echo $row2d['estado']; ?></span>
                                                            </td>
                                                            <td class="text-center ">
                                                                <b>
                                                                    <a href="#" class="text-info">
                                                                        <?php echo $row2d['numero_despacho']; ?>
                                                                    </a>
                                                                </b>
                                                            </td>
                                                            <?php
                                                            $total_tallasd = 0;
                                                            $sql1d = "SELECT pd.talla FROM pedido p, pedido_detalle pd WHERE p.id=pd.id_pedido AND p.fecha BETWEEN '" . $fecha_desde . "' AND '" . $fecha_hasta . "' AND p.nombre_tercero='$nombre_tercero' AND p.estado!='Cancelado'
                                                                UNION 
                                                                SELECT dd.talla FROM despacho d, despacho_detalle dd WHERE d.id=dd.id_despacho AND d.fecha BETWEEN '" . $fecha_desde . "' AND '" . $fecha_hasta . "' AND d.nombre_tercero='$nombre_tercero' AND d.estado!='Cancelado'";
                                                            $query1d = $conn->query($sql1d);
                                                            if ($query1d->num_rows > 0) {
                                                                while ($row1d = $query1d->fetch_assoc()) {


                                                                    $sql3d = "SELECT SUM(cantidad) as cantidad FROM despacho_detalle WHERE id_despacho='" . $row2d['id'] . "' AND referencia_producto='" . $row['referencia_producto'] . "' AND talla='" . $row1d['talla'] . "'";
                                                                    $query3d = $conn->query($sql3d);
                                                                    $row3d = $query3d->fetch_assoc();
                                                                    ?>
                                                                    <td class="text-center p-1">- <?php echo $row3d['cantidad']; ?></td>
                                                                    <?php
                                                                    $total_tallasd += $row3d['cantidad'];
                                                                }
                                                            }
                                                            ?>
                                                            <td class="text-end">
                                                                <b>- <?php echo number_format($total_tallasd, 0); ?></b>
                                                            </td>


                                                        </tr>
                                                        <?php
                                                    }
                                                }
                                                ?>
                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                    <th class="text-end" colspan="3">SALDOS</th>
                                                    <?php
                                                    $total_tallas = 0;
                                                    $total_saldos = 0;
                                                    $sql4 = "SELECT pd.talla FROM pedido p, pedido_detalle pd WHERE p.id=pd.id_pedido AND p.fecha BETWEEN '" . $fecha_desde . "' AND '" . $fecha_hasta . "' AND p.nombre_tercero='$nombre_tercero'  AND p.estado!='Cancelado'
                                                                UNION 
                                                                SELECT dd.talla FROM despacho d, despacho_detalle dd WHERE d.id=dd.id_despacho AND d.fecha BETWEEN '" . $fecha_desde . "' AND '" . $fecha_hasta . "' AND d.nombre_tercero='$nombre_tercero' AND d.estado!='Cancelado'";
                                                    $query4 = $conn->query($sql4);
                                                    if ($query4->num_rows > 0) {
                                                        while ($row4 = $query4->fetch_assoc()) {


                                                            $sql5 = "SELECT SUM(pd.cantidad) as cantidad FROM pedido p, pedido_detalle pd "
                                                                    . "WHERE p.id=pd.id_pedido AND p.fecha BETWEEN '" . $fecha_desde . "' AND '" . $fecha_hasta . "' AND p.nombre_tercero='$nombre_tercero' AND "
                                                                    . "pd.referencia_producto='" . $row['referencia_producto'] . "' AND pd.talla='" . $row4['talla'] . "' AND p.estado!='Cancelado'";
                                                            $query5 = $conn->query($sql5);
                                                            $row5 = $query5->fetch_assoc();

                                                            $sql6 = "SELECT SUM(dd.cantidad) as cantidad FROM despacho d, despacho_detalle dd "
                                                                    . "WHERE d.id=dd.id_despacho AND d.fecha BETWEEN '" . $fecha_desde . "' AND '" . $fecha_hasta . "' AND d.nombre_tercero='$nombre_tercero' AND "
                                                                    . "dd.referencia_producto='" . $row['referencia_producto'] . "' AND dd.talla='" . $row4['talla'] . "'  AND d.estado!='Cancelado'";
                                                            $query6 = $conn->query($sql6);
                                                            $row6 = $query6->fetch_assoc();

                                                            $saldos = $row5['cantidad'] - $row6['cantidad'];
                                                            ?>
                                                            <th class="text-center p-1"><?php echo number_format($saldos, 0); ?></th>
                                                                <?php
                                                                $total_saldos += $saldos;
                                                            }
                                                        }
                                                        ?>
                                                            <th class="text-end">
                                                        <?php echo number_format($total_saldos, 0); ?>
                                                    </th>
                                                </tr>
                                            </tfoot>
                                        </table>
                                
                                
                                <hr>

                                        <?php
                                    }
                                }
                                ?>

                            </div>
                            <?php
                        } else {
                            
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>


        <?php echo include '../general/libreria-js.php'; ?>
        <script src="../../assets/plugins/datatable/js/jquery.dataTables.min.js"></script>
        <script src="../../assets/plugins/datatable/js/dataTables.bootstrap5.min.js"></script>


       <script>
    // Tablas con la clase "tabla-datatable"
    $(document).ready(function () {
        $('.tabla-datatable').each(function () {
            var table = $(this).DataTable({
                paging: false,
                lengthChange: false,
                searching: false,
                "columnDefs": [
                    {"orderable": false, "targets": "_all"}, // Desactiva ordenamiento para todas las columnas
                ],
                order: [[0, 'asc']],
              
            });

            table.buttons().container()
                .appendTo($(this).closest('.dataTables_wrapper').find('.col-md-6:eq(0)'));
        });
    });
</script>


    </body>
</html>