<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';

if (isset($_GET['filtro'])) {
    $fecha_desde = $_GET['fecha_desde'];
    $fecha_hasta = $_GET['fecha_hasta'];
    $nombre_tercero = 'TODO';
} else {
    $fecha_desde = $_GET['fecha_desde'];
    $fecha_hasta = $_GET['fecha_hasta'];
    $nombre_tercero = 'TODO';
}
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">


                    <nav aria-label="breadcrumb">

                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="../inicio/inicio.php"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            
                            <li class="breadcrumb-item">Reporte de empleados</li>
                        </ol>


                    </nav>


                    <div class="row">
                        <div class="col-sm-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="p-2 border rounded">

                                        <form method="GET" action="rpt-general-empleados.php" class=" d-print-none">

                                            <div class="row">
                                                <div class="col-6 col-sm-2">
                                                    <div class="form-group">
                                                        <label>Desde</label>
                                                        <input type="date" class="form-control form-control-sm" name="fecha_desde" value="<?php echo $fecha_desde; ?>" required>  
                                                    </div>
                                                </div>
                                                <div class="col-6 col-sm-2">
                                                    <div class="form-group">
                                                        <label>Hasta</label>
                                                        <input type="date" class="form-control form-control-sm" name="fecha_hasta" value="<?php echo $fecha_hasta; ?>" required>  
                                                    </div>
                                                </div>

                                                <div class="col-5 col-sm-2 pt-3">
                                                    <div class="form-group">
                                                        <button class="btn btn-primary px-2 radius-10 " type="submit" name="filtro" style="width: 100%;">
                                                            Consultar
                                                        </button>  
                                                    </div>
                                                </div>
                                            </div>
                                        </form>


                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                    <?php
                    if (isset($_GET['filtro'])) {

                        $fecha_desde = $_GET['fecha_desde'];
                        $fecha_hasta = $_GET['fecha_hasta'];

                        if ($nombre_tercero == 'TODO') {
                            $sql_nombre_tercero = "";
                            $sql_nombre_tercero1 = "";
                            $sql_produccion = "";
                        } else {
                            $sql_nombre_tercero = "AND (nombre_tercero_1='$nombre_tercero' OR nombre_tercero_2='$nombre_tercero' OR nombre_tercero_3='$nombre_tercero') ";
                            $sql_nombre_tercero1 = " AND (p.nombre_tercero_1='$nombre_tercero' OR p.nombre_tercero_2='$nombre_tercero' OR p.nombre_tercero_3='$nombre_tercero') ";
                            $sql_produccion = " AND nombre='$nombre_tercero' ";
                        }


                        $sql_fecha = "fecha BETWEEN '" . $fecha_desde . "' AND '" . $fecha_hasta . "'";
                        $sql_fecha1 = "p.fecha BETWEEN '" . $fecha_desde . "' AND '" . $fecha_hasta . "'";

                        $sql = $sql_fecha . $sql_nombre_tercero;
                        $sql1 = $sql_fecha1 . $sql_nombre_tercero1;
                        ?>


                        <div class="card">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-sm-4">
                                    </div>
                                    <div class="col-sm-4">
                                        <h6 class=" mb-3 text-center"><b>REPORTE DE PRODUCCION POR EMPLEADOS <br><br>
                                                <?php echo strftime("%d - %B - %Y", strtotime(date($fecha_desde))); ?> <strong class="text-info">al</strong> <?php echo strftime("%d - %B - %Y", strtotime(date($fecha_hasta))); ?></b></h6>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end page title -->
                        <style>
                            #hover_enlace:hover{
                                color: orange;
                                border-radius: 10px; border: #3fc3ee 1px solid;
                                box-shadow: 0px 0px 5px 0px #3fc3ee;
                            }

                        </style>


                        <div class="row">
                            <div class="col-sm-3 ">
                                <div class="card ">
                                    <div class="card-body bg-light-dark" style="height: 895px;">
                                        <h6><b>Produccion de <?php echo ucfirst(strftime("%B", strtotime(date("F")))); ?></b> </h6>

                                        <hr>
                                        <span><i class="fa-solid fa-boxes-stacked"></i> | Acumulado del mes por empleado</span><br>
                                        <span><i class="fa-solid fa-flag-checkered"></i> | Meta del mes: <?php echo number_format($meta, 0); ?> pares</span>
                                        <br>
                                        <br>


                                        <div class="overflow-auto bg-white"  style="height: 700px; ">



                                            <?php
                                            $total_monto = 0;
                                            $total_ordenes = 0;
                                            $total_prendas = 0;

                                            $sql7 = "SELECT * FROM tercero WHERE tipo='Empleado' $sql_produccion";
                                            $query7 = $conn->query($sql7);
                                            if ($query7->num_rows > 0) {
                                                while ($row7 = $query7->fetch_assoc()) {

                                                    $nombre_tercero1 = $row7['nombre'];

                                                    $sql8 = "SELECT SUM(pd.cantidad) as total_produccion "
                                                            . "FROM produccion p, produccion_detalle pd "
                                                            . "WHERE p.id=pd.id_produccion AND $sql_fecha1 AND "
                                                            . "(p.nombre_tercero_1='$nombre_tercero1' OR p.nombre_tercero_2='$nombre_tercero1' OR p.nombre_tercero_3='$nombre_tercero1')";
                                                    $query8 = $conn->query($sql8);
                                                    $row8 = $query8->fetch_assoc();

                                                    $sql9 = "SELECT COUNT(id) as contar_produccion "
                                                            . "FROM produccion "
                                                            . "WHERE  $sql_fecha AND "
                                                            . "(nombre_tercero_1='$nombre_tercero1' OR nombre_tercero_2='$nombre_tercero1' OR nombre_tercero_3='$nombre_tercero1') ";
                                                    $query9 = $conn->query($sql9);
                                                    $row9 = $query9->fetch_assoc();

                                                    if ($row8['total_produccion'] <= 0) {
                                                        $porcentaje1 = 0;
                                                    } else {
                                                        $porcentaje1 = 100 / ($meta / $row8['total_produccion']);
                                                    }




                                                    $porcentaje1 = number_format($porcentaje1, 1);

                                                    if ($porcentaje1 > 0 && $porcentaje1 < 20) {
                                                        $porcentaje_color = 'bg-danger';
                                                    } elseif ($porcentaje1 > 19 && $porcentaje1 < 80) {
                                                        $porcentaje_color = 'bg-warning';
                                                    } elseif ($porcentaje1 > 79 && $porcentaje1 < 100) {
                                                        $porcentaje_color = 'bg-info';
                                                    } elseif ($porcentaje1 > 99) {
                                                        $porcentaje_color = 'bg-success';
                                                    }
                                                    ?>

                                                    <style>
                                                        #panel_estado_progreso:hover{
                                                            border-radius: 10px; border: #8ab0e9 2px solid;
                                                        }

                                                    </style>


                                                    <div class = "p-2" id = "panel_estado_progreso">
                                                        <a href = "rpt-empleado.php?empleado=<?php echo $row7['nombre']; ?>&&fecha_desde=<?php echo $fecha_desde; ?>&&fecha_hasta=<?php echo $fecha_hasta; ?>" >
                                                            <div class = "card radius-10 shadow-none mb-0 text-dark" >
                                                                <div class = "d-flex align-items-center gap-3">

                                                                    <h6 class = "mb-0"><strong><?php echo $row7['nombre']; ?></strong></h6>
                                                                    <div class="ms-auto"><b> <?php echo number_format($row8['total_produccion']); ?> </b><b class="text-secondary"> | Pares</b></div>
                                                                </div>
                                                                <span class="text-secondary " style="font-size: 12px;">Ordenes de produccion <b><?php echo $row9['contar_produccion']; ?></b> </span>
                                                                <div class="progress">
                                                                    <div class="progress-bar progress-bar-striped progress-bar-animated <?php echo $porcentaje_color; ?>" role="progressbar" style="width: <?php echo $porcentaje1; ?>%;" aria-valuenow="<?php echo $porcentaje1; ?>" aria-valuemin="0" aria-valuemax="100"><?php echo $porcentaje1; ?>%</div>
                                                                </div>
                                                            </div>
                                                        </a>
                                                    </div>
                                                    <hr>




                                                    <?php
                                                    $total_monto += $row8['total_produccion'];
                                                    $total_ordenes += $row9['contar_produccion'];
                                                }
                                            }
                                            ?>
                                        </div>         

        




                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-9">
                                <div class="card">
                                    <div class="card-body">
                                        <div class=" mt-2 table-responsive" >
                                            <table class="table align-middle mb-0 table-striped table-bordered table-sm" border="1" id="example2" style="">
                                                <thead class="">
                                                    <tr class="bg-gradient-purple text-white">
                                                        <th class="text-center" style="width: 8%;">FECHA</th>
                                                        <th class="text-center ">No</th>
                                                        <th class=" " style="width: 15%;">ENCARGADO</th>
                                                        <th class="text-center">MATERIAL</th>
                                                        <th class="text-center">CANT.</th>
                                                        <th class="text-center">COMISION</th>
                                                        <th class="text-center">A PAGAR</th>
                                                        <th class="text-center">VER</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php
                                                    $total_pares = 0;
                                                    $total_pagar = 0;
                                                    $sql = "SELECT * FROM produccion WHERE $sql  ORDER BY fecha desc";
                                                    $query = $conn->query($sql);
                                                    if ($query->num_rows > 0) {
                                                        while ($row = $query->fetch_assoc()) {

                                                            $sql1 = "SELECT SUM(cantidad) as cantidad FROM produccion_detalle WHERE id_produccion='" . $row['id'] . "'";
                                                            $query1 = $conn->query($sql1);
                                                            $row1 = $query1->fetch_assoc();

                                                            $sql2 = "SELECT p.categoria "
                                                                    . "FROM produccion_detalle pd, producto p "
                                                                    . "WHERE p.referencia=pd.referencia_producto AND id_produccion='" . $row['id'] . "' GROUP BY p.categoria ";
                                                            $query2 = $conn->query($sql2);
                                                            $row2 = $query2->fetch_assoc();

                                                            if (isset($row['nombre_tercero_1'])) {
                                                                $encargado = 1;
                                                            } else {
                                                                $encargado = 0;
                                                            }

                                                            if (isset($row['nombre_tercero_2'])) {
                                                                $ayudante_1 = 1;
                                                            } else {
                                                                $ayudante_1 = 0;
                                                            }

                                                            if (isset($row['nombre_tercero_3'])) {
                                                                $ayudante_2 = 1;
                                                            } else {
                                                                $ayudante_2 = 0;
                                                            }


                                                            $total_operarios = $encargado + $ayudante_1 + $ayudante_2;

                                                            if (isset($row2['categoria'])) {
                                                                $material = $row2['categoria'];

                                                                if ($row2['categoria'] == 'EXPANSO') {
                                                                    if ($total_operarios > 1) {
                                                                        $comision = 7;
                                                                    } elseif ($total_operarios == 1) {
                                                                        $comision = 10;
                                                                    } else {
                                                                        $comision = 0;
                                                                    }
                                                                } elseif ($row2['categoria'] == 'PVC') {
                                                                    if ($total_operarios > 0) {
                                                                        $comision = 6;
                                                                    } else {
                                                                        $comision = 0;
                                                                    }
                                                                }
                                                            } else {
                                                                $material = '';
                                                            }


                                                            if (isset($row1['cantidad'])) {
                                                                $cantidad = $row1['cantidad'];
                                                            } else {
                                                                $cantidad = 0;
                                                            }




                                                            $pagar = $cantidad * $comision;
                                                            ?>
                                                            <tr class="align-middle" id="hover_enlace" >
                                                                <td class="text-center">
                                                                    <b class="text-secondary"><?php echo date('d-m-Y', strtotime($row['fecha'])); ?></b>
                                                                </td>
                                                                <td class="text-center text-primary">
                                                                    <b><?php echo $row['numero_produccion']; ?></b>
                                                                </td>  
                                                                <td class="">

                                                                    <?php
                                                                    if ($nombre_tercero == 'TODO') {
                                                                        echo "<b>" . $row['nombre_tercero_1'] . "</b> <br>";

                                                                        if ($row['nombre_tercero_2'] == NULL) {
                                                                            echo '---';
                                                                        } else {
                                                                            echo $row['nombre_tercero_2'];
                                                                        }
                                                                        ?>
                                                                        <br>
                                                                        <?php
                                                                        if ($row['nombre_tercero_3'] == NULL) {
                                                                            echo '---';
                                                                        } else {
                                                                            echo $row['nombre_tercero_3'];
                                                                        }
                                                                        ////
                                                                    } else {
                                                                        if ($row['nombre_tercero_1'] == $nombre_tercero) {
                                                                            echo "<b>" . $row['nombre_tercero_1'] . "</b>";
                                                                        } else {
                                                                            echo $row['nombre_tercero_1'];
                                                                        }
                                                                        ?>

                                                                        <br>
                                                                        <?php
                                                                        if ($row['nombre_tercero_2'] == NULL) {
                                                                            echo '---';
                                                                        } else {
                                                                            if ($row['nombre_tercero_2'] == $nombre_tercero) {
                                                                                echo "<b>" . $row['nombre_tercero_2'] . "</b>";
                                                                            } else {
                                                                                echo $row['nombre_tercero_2'];
                                                                            }
                                                                        }
                                                                        ?>
                                                                        <br>
                                                                        <?php
                                                                        if ($row['nombre_tercero_3'] == NULL) {
                                                                            echo '---';
                                                                        } else {

                                                                            if ($row['nombre_tercero_3'] == $nombre_tercero) {
                                                                                echo "<b>" . $row['nombre_tercero_3'] . "</b>";
                                                                            } else {
                                                                                echo $row['nombre_tercero_3'];
                                                                            }
                                                                        }
                                                                    }
                                                                    ?>


                                                                </td> 
                                                                <td class="text-center">
                                                                    <b><?php echo $material; ?></b>
                                                                </td>
                                                                <td class="text-center">
                                                                    <b><?php echo number_format($row1['cantidad'], 0); ?></b>
                                                                </td>
                                                                <td class="text-center ">
                                                                    <b class="text-info">$</b> <b><?php echo number_format($comision, 0); ?></b>
                                                                </td>
                                                                <td class="text-end h6">
                                                                    <b class="float-start text-secondary">$</b> <b class="text-primary"><?php echo number_format($pagar, 0); ?></b>
                                                                </td>

                                                                <td class="text-center">
                                                                    <a href="javascript:window.open('../produccion/produccion-detalle.php?id_produccion=<?php echo $row['id']; ?>','','width=1200,height=700,left=100,top=10,toolbar=yes');void 0">
                                                                        <i class="fa-solid fa-eye fa-2x"></i>
                                                                    </a>
                                                                </td>
                                                            </tr>
            <?php
            $total_pares += $row1['cantidad'];
            $total_pagar += $pagar;
        }
    }
    ?>
                                                </tbody>
                                                <tfoot>
                                                    <tr class="bg-light-dark h6">
                                                        <td class="text-end" colspan="4"><b>TOTAL</b></td>
                                                        <td class="text-center"><b><?php echo number_format($total_pares, 0); ?></b></td>
                                                        <td></td>
                                                        <td class="text-end">
                                                            <b class="float-start text-secondary">$</b><b><?php echo number_format($total_pagar, 0); ?></b>
                                                        </td>
                                                        <td></td>
                                                    </tr>

                                                </tfoot>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

    <?php
} else {
    
}
?>






                </div><!-- end col -->
                <!-- end page content-->
            </div>
            <!--end page content wrapper-->

<?php echo include '../general/footer.php'; ?>

        </div>

            <?php echo include '../general/libreria-js.php'; ?>
        <script src="../../assets/plugins/datatable/js/jquery.dataTables.min.js"></script>
        <script src="../../assets/plugins/datatable/js/dataTables.bootstrap5.min.js"></script>
        <script>
            //Tabla producto
            $(document).ready(function () {
                var table = $('#example2').DataTable({
                    lengthChange: false,
                    buttons: [
                        {
                            extend: 'excel',
                            text: 'EXCEL',
                            filename: 'PRODUCCION  <?php echo strftime("%d - %B - %Y", strtotime($fecha_desde)); ?> al  <?php echo strftime("%d - %B - %Y", strtotime($fecha_hasta)); ?>', // Aquí defines el nombre del archivo
                            title: null,
                        },
                        {
                            extend: 'pdf',
                            text: 'PDF',
                            filename: 'PRODUCCION  <?php echo strftime("%d - %B - %Y", strtotime($fecha_desde)); ?> al  <?php echo strftime("%d - %B - %Y", strtotime($fecha_hasta)); ?>', // Aquí defines el nombre del archivo
                            title: null,
                        }
                    ],
                    "order": false,
                });

                table.buttons().container()
                        .appendTo('#example2_wrapper .col-md-6:eq(0)');
            });

        </script>
    </body>
</html>