<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';

if (isset($_GET['filtro'])) {
    $fecha_desde = $_GET['fecha_desde'];
    $fecha_hasta = $_GET['fecha_hasta'];
    $nombre_tercero = $_GET['nombre_tercero'];
    $estado = $_GET['estado'];
} else {
    $fecha_desde = date("Y-m-d");
    $fecha_hasta = date("Y-m-d");
}
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <?php include '../general/libreria-css.php'; ?>

    </head>
    <body>
        <div class="container-fluid p-5 ">

            <div class="page-content">

                <nav aria-label="breadcrumb" class="d-print-none">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="../inicio/inicio.php"> 
                                <ion-icon name="home-outline"></ion-icon>
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">RPT - Despacho por detalle</li>
                    </ol>
                </nav>

                <div class="card d-print-none">
                    <div class="card-body text-center">
                        <h3><b> DESPACHO DETALLADO POR REFERENCIA</b></h3>
                    </div>
                </div>

                <div class="row d-print-none">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="p-2 border rounded ">
                                    <form method="GET" action="rpt-despacho-detalle.php" class=" d-print-none">
                                        <div class="row">
                                            <div class="col-6 col-sm-2 ">
                                                <div class="form-group">
                                                    <label>Desde</label>
                                                    <input type="date" class="form-control form-control-sm" name="fecha_desde" value="<?php echo $fecha_desde; ?>" required>  
                                                </div>
                                            </div>
                                            <div class="col-6 col-sm-2">
                                                <div class="form-group">
                                                    <label>Hasta</label>
                                                    <input type="date" class="form-control form-control-sm" name="fecha_hasta" value="<?php echo $fecha_hasta; ?>" required>  
                                                </div>
                                            </div>

                                            <div class="col-sm-5">
                                                <div class="form-group">
                                                    <label>TERCERO</label>
                                                    <select class="single-select form-control-sm" name="nombre_tercero" required autofocus="">

                                                        <?php
                                                        if (isset($_GET['filtro'])) {

                                                            if ($nombre_tercero != 'todo') {
                                                                ?>
                                                                <option value="<?php echo $nombre_tercero; ?>"><?php echo $nombre_tercero; ?></option>
                                                                <option value="" disabled="" >Seleccione</option>
                                                                <option value="TODO" >TODO</option>

                                                                <?php
                                                            } else {
                                                                ?>

                                                                <option value="" disabled="" selected="">Seleccione</option>
                                                                <option value="TODO" >TODO</option>
                                                                <?php
                                                            }
                                                        } else {
                                                            ?>
                                                            <option value="" disabled="" selected="">Seleccione</option>
                                                            <option value="TODO" >TODO</option>
                                                            <?php
                                                        }



                                                        $sql6m = "SELECT * FROM tercero";
                                                        $query6m = $conn->query($sql6m);
                                                        if ($query6m->num_rows > 0) {
                                                            while ($row6m = $query6m->fetch_assoc()) {
                                                                ?>
                                                                <option value="<?php echo $row6m['nombre'] ?>"><?php echo $row6m['nombre'] ?></option>
                                                                <?php
                                                            }
                                                        }
                                                        ?>
                                                    </select>  
                                                </div>
                                            </div>
                                            <div class="col-6 col-sm-2">
                                                <div class="form-group">
                                                    <label>ESTADO</label>
                                                    <select class="single-select form-control-sm" name="estado" required autofocus="">

                                                        <?php
                                                        if (isset($_GET['filtro'])) {

                                                            if ($estado != 'todo') {
                                                                ?>
                                                                <option value="<?php echo $estado; ?>"><?php echo $estado; ?></option>
                                                                <option value="" disabled="" >Seleccione</option>
                                                                <option value="TODO" >TODO</option>

                                                                <?php
                                                            } else {
                                                                ?>

                                                                <option value="" disabled="" selected="">Seleccione</option>
                                                                <option value="TODO" >TODO</option>
                                                                <?php
                                                            }
                                                        } else {
                                                            ?>
                                                            <option value="" disabled="" selected="">Seleccione</option>
                                                            <option value="TODO" >TODO</option>
                                                            <?php
                                                        }
                                                        ?>

                                                        <option value="Proceso">Proceso</option>
                                                        <option value="Enviado">Enviado</option>
                                                        <option value="Novedad">Novedad</option>
                                                        <option value="Entregado">Entregado</option>
                                                        <option value="Cancelado">Cancelado</option>


                                                    </select>  
                                                </div>
                                            </div>
                                            <div class="col-5 col-sm-1 pt-3">
                                                <div class="form-group">
                                                    <button class="btn btn-primary px-2 radius-30" type="submit" name="filtro" style="width: 100%;">
                                                        Consultar
                                                    </button>  
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>



                <div class="card ">
                    <div class="card-body">






                        <?php
                        if (isset($_GET['filtro'])) {

                            $fecha_desde = $_GET['fecha_desde'];
                            $fecha_hasta = $_GET['fecha_hasta'];
                            $nombre_tercero = $_GET['nombre_tercero'];

                            if ($nombre_tercero == 'TODO') {
                                $sql_nombre_tercero = "";
                            } else {
                                $sql_nombre_tercero = " AND d.nombre_tercero='" . $nombre_tercero . "'";
                            }

                            if ($estado == 'TODO') {
                                $sql_estado = "";
                            } else {
                                $sql_estado = " AND d.estado='" . $estado . "'";
                            }


                            $sql_fecha = "AND d.fecha BETWEEN '" . $fecha_desde . "' AND '" . $fecha_hasta . "' ";

                            $sql = $sql_fecha . $sql_nombre_tercero . $sql_estado;
                            ?>
                            <div class=" mt-3">
                                <div class="d-print-none">
                                    <div class="float-end">
                                        <a href="javascript:window.print()" class="btn btn-info waves-effect waves-light">
                                            <i class="fas fa-print"></i>
                                        </a>
                                    </div>
                                    <div class="clearfix"></div>
                                </div>


                                <?php
                                if ($nombre_tercero == 'TODO') {
                                    $nit = 'No aplica';
                                } else {
                                    $sqlter = "SELECT * FROM tercero WHERE nombre='$nombre_tercero'";
                                    $queryter = $conn->query($sqlter);
                                    $rowter = $queryter->fetch_assoc();

                                    $nit = $rowter['nit'];
                                }
                                ?>
                                <div class="p-2 rounded">




                                    <div class="row">
                                        <div class="col-sm-2 text-center">
                                            <img src="../../img/logo.png" class="logo-icon"  alt="logo icon" width="80">

                                        </div> 

                                        <div class="col-sm-8 text-start">
                                            <h6 class="text-dark mt-0 mb-1"><b>REPORTE DE DESPACHO</b></h6>

                                            <h6 class="text-dark mt-0 mb-1"><b> <?php echo $nombre_tercero; ?></b></h6>  
                                            <h6 class="text-dark mt-0 mb-1"><b>NIT: </b><?php echo $nit; ?></h6> 
                                            <h6 class="text-dark mt-0 mb-0">
                                                <?php echo strftime("%d - %B - %Y", strtotime($fecha_desde)); ?> 
                                                <b class="ms-3 me-3">|</b> 
                                                <?php echo strftime("%d - %B - %Y", strtotime($fecha_hasta)); ?>
                                            </h6> 

                                        </div>
                                    </div>
                                </div>

                                <style>
                                    #hover_enlace:hover{
                                        color: purple;
                                        border-radius: 10px; 
                                        box-shadow: 0px 0px 10px 0px purple;
                                    }



                                </style>


                                <div class="  " style="overflow: auto;"> 
                                    <table class="table table-bordered table-striped table-hover" id="example2">
                                        <thead>
                                            <tr class="bg-gradient-info text-white">
                                                <th class="text-center "  >REFERENCIA</th>
                                                <?php
                                                $item = 0;
                                                $sqlt1 = "SELECT dd.talla "
                                                        . "FROM despacho_detalle dd, despacho d "
                                                        . "WHERE d.id=dd.id_despacho $sql GROUP BY dd.talla ORDER BY dd.talla asc";
                                                $queryt1 = $conn->query($sqlt1);
                                                if ($queryt1->num_rows > 0) {
                                                    while ($rowt1 = $queryt1->fetch_assoc()) {
                                                        ?>
                                                        <th class="text-center p-1"><?php echo $rowt1['talla']; ?></th>
                                                        <?php
                                                        $item++;
                                                    }
                                                }
                                                ?>
                                                <th class="text-center " >T. PARES</th>
                                                <th class="text-center " >VR. UNIT</th>
                                                <th class="text-center " >PQTS</th>
                                                <th class="text-center "  style="width: 10%;">VR. TOTAL</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $total_cantidad = 0;
                                            $total_venta = 0;
                                            $total_paquetes = 0;

                                            $sql3 = "SELECT dd.referencia_producto, dd.precio_unidad "
                                                    . "FROM despacho_detalle dd, despacho d "
                                                    . "WHERE d.id=dd.id_despacho $sql GROUP BY dd.referencia_producto, dd.precio_unidad";
                                            $query3 = $conn->query($sql3);
                                            if ($query3->num_rows > 0) {
                                                while ($row3 = $query3->fetch_assoc()) {

                                                    $sql2 = "SELECT * FROM producto WHERE referencia='" . $row3['referencia_producto'] . "'";
                                                    $query2 = $conn->query($sql2);
                                                    $row2 = $query2->fetch_assoc();

                                                    ////CANTIDAD POR REFERENCIA
                                                    $sqlCANT = "SELECT SUM(dd.cantidad) as cantidad_referencia "
                                                            . "FROM despacho_detalle dd, despacho d "
                                                            . "WHERE d.id=dd.id_despacho  $sql "
                                                            . "AND dd.referencia_producto='" . $row3['referencia_producto'] . "'  AND dd.precio_unidad='" . $row3['precio_unidad'] . "'";
                                                    $queryCANT = $conn->query($sqlCANT);
                                                    $rowCANT = $queryCANT->fetch_assoc();
                                                    ?>
                                                    <tr class="align-middle">
                                                        <td> 
                                                            <strong class=""><?php echo $row2['referencia']; ?></strong>
                                                        </td>

                                                        <?php
                                                        $queryt2 = $conn->query($sqlt1);
                                                        if ($queryt2->num_rows > 0) {
                                                            while ($rowt2 = $queryt2->fetch_assoc()) {

                                                                $sqlt4 = "SELECT SUM(dd.cantidad) as suma_talla "
                                                                        . "FROM despacho_detalle dd, despacho d "
                                                                        . "WHERE d.id=dd.id_despacho  $sql AND dd.referencia_producto='" . $row3['referencia_producto'] . "' AND dd.talla='" . $rowt2['talla'] . "' AND dd.precio_unidad='" . $row3['precio_unidad'] . "'";
                                                                $queryt4 = $conn->query($sqlt4);
                                                                $rowt4 = $queryt4->fetch_assoc();

                                                                $suma_talla = $rowt4['suma_talla'];
                                                                ?>
                                                                <td class="ancho text-center">
                                                                    <b class="text-secondary"><?php echo $suma_talla; ?></b>
                                                                </td>
                                                                <?php
                                                            }
                                                        }
                                                        ?>



                                                        <td class="text-center"><b><?php echo number_format($rowCANT['cantidad_referencia']); ?></b></td>  
                                                        <td class="" style="text-align: right;">
                                                            <b class="float-start">$</b> <?php echo number_format($row3['precio_unidad'], 0, '.', ','); ?>
                                                        </td> 

                                                        <td class="text-center">


                                                            <?php
                                                            $sql7 = "SELECT SUM(dd.cantidad) AS cantidad "
                                                                    . "FROM despacho_paquete dd, despacho d "
                                                                    . "WHERE d.id=dd.id_despacho  $sql AND dd.referencia_producto='" . $row3['referencia_producto'] . "' AND dd.precio_unidad='" . $row3['precio_unidad'] . "'";
                                                            $query7 = $conn->query($sql7);
                                                            $row7 = $query7->fetch_assoc();
                                                            ?>

                                                            <span>
                                                                <h6>   
                                                                    <b><?php echo number_format($row7['cantidad'], 0); ?></b>
                                                                </h6>
                                                            </span>
                                                        </td>

                                                        <td class="" style="text-align: right; ">
                                                            <b class="float-start">$</b> 
                                                            <b class="h6"><b><?php echo number_format($rowCANT['cantidad_referencia'] * $row3['precio_unidad'], 0, '.', ','); ?></b></b>
                                                        </td>
                                                    </tr>
                                                    <?php
                                                    $total_venta += $rowCANT['cantidad_referencia'] * $row3['precio_unidad'];
                                                    $total_cantidad += $rowCANT['cantidad_referencia'];
                                                    $total_paquetes += $row7['cantidad'];
                                                }
                                            }
                                            ?>
                                        </tbody>
                                        <tfoot>
                                            <tr class="h5 bg-light-dark">
                                                <td class="text-end" colspan="<?php echo $item + 1; ?>"><b>TOTAL</b></td>
                                                <td class="text-center"><b><?php echo number_format($total_cantidad); ?></b></td>
                                                <td></td>
                                                <td class="text-center">
                                                    <b><?php echo $total_paquetes; ?></b>
                                                </td>
                                                <td class="text-end">
                                                    <b class="float-start">$</b> 
                                                    <b><?php echo number_format($total_venta, 0); ?></b>
                                                </td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>



                            </div>
                            <?php
                        } else {
                            
                        }
                        ?>


                    </div>
                </div>
            </div>

        </div>




        <?php echo include '../general/libreria-js.php'; ?>

        <script src="../../assets/plugins/datatable/js/jquery.dataTables.min.js"></script>
        <script src="../../assets/plugins/datatable/js/dataTables.bootstrap5.min.js"></script>




        <script>
            //Tabla producto
            $(document).ready(function () {
                var table = $('#example2').DataTable({
                    paging: false,
                    lengthChange: false,
                    "columnDefs": [
                        {"orderable": false, "targets": "_all"}, // Desactiva ordenamiento para todas las columnas
                    ],

                    order: [[<?php echo $item + 1; ?>, 'desc']],

                    buttons: [
                        {
                            extend: 'excel',
                            text: 'EXCEL',
                            filename: 'DESPACHO POR REFERENCIA  <?php echo strftime("%d - %B - %Y", strtotime($fecha_desde)); ?> al  <?php echo strftime("%d - %B - %Y", strtotime($fecha_hasta)); ?>', // Aquí defines el nombre del archivo
                            title: null,
                        },
                        {
                            extend: 'pdf',
                            text: 'PDF',
                            filename: 'DESPACHO POR REFERENCIA  <?php echo strftime("%d - %B - %Y", strtotime($fecha_desde)); ?> al  <?php echo strftime("%d - %B - %Y", strtotime($fecha_hasta)); ?>', // Aquí defines el nombre del archivo
                            title: null,
                        }
                        ],

                });

                table.buttons().container()
                        .appendTo('#example2_wrapper .col-md-6:eq(0)');
            });

        </script>


        <div class="modal fade text-start text-dark" id="cierre_pedido" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-sm">
                <div class="modal-content">
                    <div class="modal-header bg-warning">
                        <h5 class="modal-title card-heading" id="exampleModalLabel">Hacer cierre</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form class="" method="POST" action="script/cierre-pedido.php">
                        <div class="modal-body row">

                            <div class="col-sm-12 mt-2">
                                <label class="form-label" for="validationCustom01">Usuario de registro</label>
                                <input type="text" name="nombre_usuario" id="nombre_usuario" parsley-trigger="change" required readonly=""
                                       class="form-control" >
                            </div>
                            <div class="col-sm-12 mt-2">
                                <label class="form-label" for="validationCustom01">Tercero</label>
                                <input type="text" name="nombre_tercero" id="nombre_tercero" parsley-trigger="change" required readonly=""
                                       class="form-control" >
                            </div>
                            <div class="col-sm-12 mt-2">
                                <label class="form-label" for="validationCustom01">Referencia</label>
                                <input type="text" name="referencia_producto" id="referencia_producto" parsley-trigger="change" required readonly=""
                                       class="form-control" >
                            </div>
                            <div class="col-sm-12 mt-2">
                                <label class="form-label" for="validationCustom01">Talla</label>
                                <input type="text" name="talla" id="talla" parsley-trigger="change" required readonly=""
                                       class="form-control" >
                            </div>

                            <div class="col-sm-12 mt-2">
                                <label class="form-label" for="validationCustom01">Cantidad</label>

                                <input class="form-control inputcss "  type="number" required="" name="cantidad" id="cantidad" placeholder="cant." value="<?php echo $talla; ?>">
                                <div class="valid-feedback">Se ve bien!</div>
                                <div class="invalid-feedback">Por favor, Digite cantidad de prendas.</div>
                            </div>

                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-warning" name="editar" 
                                    onclick="if (!confirm('Seguro deseas hacer cierre de este registro?')) {
                                                return false

                                            }">
                                Guardar cambios</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <script>

            // PASO DE PARAMETROS EDITAR
            $('#cierre_pedido').on('show.bs.modal', function (event) {
                var button = $(event.relatedTarget) // Button that triggered the modal

                var nombre_usuario = button.data('nombre_usuario')
                var nombre_tercero = button.data('nombre_tercero')
                var referencia_producto = button.data('referencia_producto')
                var talla = button.data('talla')
                var cantidad = button.data('cantidad')

                $('#nombre_usuario').val(nombre_usuario)
                $('#nombre_tercero').val(nombre_tercero)
                $('#referencia_producto').val(referencia_producto)
                $('#talla').val(talla)
                $('#cantidad').val(cantidad)
            });

        </script>
    </body>
</html>