<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">

                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="../inicio/inicio.php"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">Inventario</li>
                        </ol>
                    </nav>



                    <?php
                    $sqlcon = "";
                    if (isset($_GET['filtro'])) {


                        $referencia = $_GET['referencia'];
                        $categoria = $_GET['categoria'];

                        if ($referencia != 'Todo' and $categoria == 'Todo') {
                            $sqlcon = "AND p.referencia='" . $referencia . "'";
                        } elseif ($categoria != 'Todo' and $referencia == 'Todo') {
                            $sqlcon = "AND p.categoria='" . $categoria . "'";
                        } elseif ($categoria != 'Todo' and $referencia != 'Todo') {
                            $sqlcon = "AND p.referencia='" . $referencia . "' AND p.categoria='" . $categoria . "'";
                        } else {
                            $sqlcon = "";
                        }
                    } else {
                        $referencia = 'Todo';
                        $categoria = 'Todo';
                    }
                    ?>


                    <div class="card">
                        <div class="card-body">
                            <div class="p-4 border rounded">
                                <form method="GET" action="prendas-bodega.php" class="  d-print-none">
                                    <div class="row" style="">
                                        <div class="col-6 col-sm-3">
                                            <div class="form-group">
                                                <label><strong>Referencia:</strong></label>
                                                <select class="single-select" name="referencia" required>

                                                    <?php
                                                    if (isset($_GET['filtro'])) {

                                                        if ($referencia != 'Todo') {
                                                            ?>
                                                            <option value="<?php echo $referencia; ?>"><?php echo $referencia; ?></option>
                                                            <option value="" disabled=""></option>
                                                            <option value="Todo">Todos</option>
                                                            <?php
                                                        } else {
                                                            ?>
                                                            <option value="Todo">Todos</option>
                                                            <option value="" disabled=""></option>
                                                            <?php
                                                        }
                                                    } else {
                                                        ?>
                                                        <option value="Todo">Todos</option>
                                                        <option value="" disabled=""></option>
                                                        <?php
                                                    }
                                                    ?>
                                                    <?php
                                                    $sqlp = "SELECT * FROM producto WHERE proceso='Bodega' ORDER BY referencia desc";
                                                    $queryp = $conn->query($sqlp);
                                                    if ($queryp->num_rows > 0) {
                                                        while ($rowp = $queryp->fetch_assoc()) {
                                                            ?>
                                                            <option value="<?php echo $rowp['referencia']; ?>"><?php echo $rowp['referencia']; ?> <?php echo $rowp['categoria']; ?></option>

                                                            <?php
                                                        }
                                                    }
                                                    ?>


                                                    ?>

                                                </select>  
                                            </div>
                                        </div>
                                        <div class="col-6 col-sm-3">
                                            <div class="form-group">
                                                <label><strong>Categorias:</strong></label>
                                                <select class="single-select" name="categoria" required>

                                                    <?php
                                                    if (isset($_GET['filtro'])) {

                                                        if ($categoria != 'Todo') {
                                                            ?>
                                                            <option value="<?php echo $categoria; ?>"><?php echo $categoria; ?></option>
                                                            <option value="" disabled=""></option>
                                                            <option value="Todo">Todos</option>
                                                            <?php
                                                        } else {
                                                            ?>
                                                            <option value="Todo">Todos</option>
                                                            <option value="" disabled=""></option>
                                                            <?php
                                                        }
                                                    } else {
                                                        ?>
                                                        <option value="Todo">Todos</option>
                                                        <option value="" disabled=""></option>
                                                        <?php
                                                    }
                                                    ?>
                                                    <?php
                                                    $sqlc = "SELECT * FROM categoria_producto ORDER BY categoria asc";
                                                    $queryc = $conn->query($sqlc);
                                                    if ($queryc->num_rows > 0) {
                                                        while ($rowc = $queryc->fetch_assoc()) {
                                                            ?>
                                                            <option value="<?php echo $rowc['categoria']; ?>"><?php echo $rowc['categoria']; ?></option>
                                                            <?php
                                                        }
                                                    }
                                                    ?>

                                                </select>                         
                                            </div>
                                        </div>
                                        <div class="col-5 col-sm-1 pt-3">
                                            <div class="form-group">
                                                <button class="btn btn-primary px-4 radius-30" type="submit" name="filtro">
                                                    Filtrar
                                                </button>
                                            </div>
                                        </div>
                                        <div class="col-5 col-sm-1 pt-3">
                                            <div class="form-group">
                                                <a href="prendas-bodega.php" class="btn btn-secondary px-2 radius-30" >
                                                    Restablecer
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>




                    <div class="card card-table mb-4">



                        <?php
                        $registro_por_pagina = 10;
                        $pagina = '';
                        if (isset($_GET["pagina"])) {
                            $pagina = $_GET["pagina"];
                        } else {
                            $pagina = 1;
                        }

                        $start_from = ($pagina - 1) * $registro_por_pagina;
                        ?>

                        <div class="card-body">



                            <div class="table-responsive">
                                <table class="table text-sm table-sm table-striped table-hover table-bordered" id="datatable3" >
                                    <thead>
                                        <tr class="bg-light-primary text-primary">
                                            <th class="" >Foto</th>
                                            <th class="" >Ref.</th>
                                            <th class="" >Marca</th>
                                            <th class="" >Categoria</th>
                                            <th class="" >Tipo</th>
                                            <th class="" >Genero</th>
                                            <?php
                                            for ($i = 34; $i < 44; $i++) {
                                                ?>
                                                <th class="text-center p-2" ><?php echo $i; ?></th>
                                                <?php
                                            }
                                            ?>
                                            <th class="text-center" >TOTAL</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $total_prendas1 = 0;
                                        $sql = "SELECT tp.referencia_producto as referencia, p.id, p.marca as marca, p.categoria as categoria, p.tipo as tipo, p.genero as genero,  p.foto1 as foto1 "
                                                . "FROM producto p, talla_producto tp "
                                                . "WHERE p.referencia=tp.referencia_producto AND p.proceso='Bodega' $sqlcon"
                                                . "GROUP BY tp.referencia_producto ORDER BY p.referencia desc, p.id desc LIMIT $start_from, $registro_por_pagina";
                                        $query = $conn->query($sql);
                                        if ($query->num_rows > 0) {
                                            while ($row = $query->fetch_assoc()) {
                                                ?>
                                                <tr class="font-11 ">
                                                    <td class="">
                                                        <a   href="#!"  data-bs-toggle="modal" data-bs-target="#foto<?php echo $row['id']; ?>">
                                                            <div class="d-flex align-items-center">
                                                                <?php
                                                                if ($row['foto1'] == 'No aplica') {
                                                                    ?>
                                                                    <img class="avatar p-1 me-2" src="../../img/logo.png" alt="Spears Collier" width="60">

                                                                    <?php
                                                                } else {
                                                                    ?>
                                                                    <img class="avatar p-1 me-2" src="../../img-producto/<?php echo $row['foto1']; ?>" alt="Spears Collier" style="max-width: 30px; max-height: 30px;">

                                                                    <?php
                                                                }
                                                                ?>

                                                            </div>
                                                        </a>
                                                        <!-- Modal -->
                                                        <div class="modal fade" id="foto<?php echo $row['id']; ?>" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                                            <div class="modal-dialog modal-lg">
                                                                <div class="modal-content">
                                                                    <div class="modal-header">
                                                                        <h5 class="modal-title card-heading" id="exampleModalLabel">Guia <?php echo $row['referencia']; ?></h5>
                                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                                    </div>
                                                                    <form class=" g-3 needs-validation" >
                                                                        <div class="modal-body ">

                                                                            <?php
                                                                            if ($row['foto1'] == 'No aplica') {
                                                                                ?>
                                                                                <img src="../../img/logo.png" width="500" frameborder="0">
                                                                                <?php
                                                                            } else {
                                                                                ?>
                                                                                <img src="../../img-producto/<?php echo $row['foto1']; ?>" width="500" frameborder="0" >

                                                                                <?php
                                                                            }
                                                                            ?>

                                                                        </div>
                                                                    </form>
                                                                </div>
                                                            </div>
                                                        </div>

                                                    </td>
                                                    <td>
                                                        <a href="../producto/kardex.php?referencia=<?php echo $row['referencia']; ?>" target="_blank">

                                                            <div class="pt-1">
                                                                <strong class="text-info"><?php echo $row['referencia']; ?></strong><br>
                                                            </div>
                                                        </a>
                                                    </td>
                                                    <td class=""><?php echo $row['marca']; ?></td>
                                                    <td class=""><?php echo $row['categoria']; ?></td>
                                                    <td class=""><?php echo $row['tipo']; ?></td>
                                                    <td class=""><?php echo $row['genero']; ?></td>


                                                    <?php
                                                    $total_tallas1 = 0;
                                                    for ($i = 34; $i < 44; $i++) {

                                                        $sql1 = "SELECT SUM(cantidad) AS cantidad FROM talla_producto WHERE referencia_producto='" . $row['referencia'] . "' AND talla='$i'";
                                                        $query1 = $conn->query($sql1);
                                                        $row1 = $query1->fetch_assoc();

                                                        $sql2 = "SELECT SUM(cantidad) AS cantidad_fuera FROM venta_detalle WHERE referencia_producto='" . $row['referencia'] . "' AND talla='$i' AND (estado='Proceso' OR estado='Confirmado' OR estado='Alistamiento' OR estado='Enviado' OR estado='Novedad' OR estado='Entregado')";
                                                        $query2 = $conn->query($sql2);
                                                        $row2 = $query2->fetch_assoc();

                                                        $sql3 = "SELECT SUM(cantidad) AS cantidad_entrada FROM novedad WHERE referencia_producto='" . $row['referencia'] . "' AND talla='$i' AND movimiento='Entrada' ";
                                                        $query3 = $conn->query($sql3);
                                                        $row3 = $query3->fetch_assoc();

                                                        $sql4 = "SELECT SUM(cantidad) AS cantidad_salida FROM novedad WHERE referencia_producto='" . $row['referencia'] . "' AND talla='$i' AND movimiento='Salida' ";
                                                        $query4 = $conn->query($sql4);
                                                        $row4 = $query4->fetch_assoc();

                                                        $sql5 = "SELECT SUM(cantidad) AS cantidad_compra FROM compra_detalle WHERE referencia_producto='" . $row['referencia'] . "' AND talla='$i'";
                                                        $query5 = $conn->query($sql5);
                                                        $row5 = $query5->fetch_assoc();

                                                        $disponibilidad1 = ($row1['cantidad'] + $row3['cantidad_entrada'] + $row5['cantidad_compra']) - ($row2['cantidad_fuera'] + $row4['cantidad_salida']);

                                                        if ($disponibilidad1 > 0) {
                                                            $color_campo = 'text-success';
                                                            $texto = 'background-color: #bceed5';
                                                        } elseif ($disponibilidad1 < 0) {
                                                            $color_campo = 'text-danger';
                                                            $texto = 'background-color: #ffc5e6';
                                                        } else {
                                                            $color_campo = '';
                                                            $texto = '';
                                                        }
                                                        ?>
                                                        <td class="text-center font-12 <?php echo $color_campo ?>" style="<?php echo $texto; ?>">
                                                            <?php echo $disponibilidad1; ?>
                                                        </td>
                                                        <?php
                                                        $total_tallas1 += $disponibilidad1;
                                                    }
                                                    ?>
                                                    <td class="text-center font-14"> <strong><?php echo $total_tallas1; ?></strong></td>

                                                </tr>
                                                <?php
                                                $total_prendas1 += $total_tallas1;
                                            }
                                        }
                                        ?>
                                    </tbody>
                                </table>
                            </div>

                            <?php
                            $sql2 = "SELECT tp.referencia_producto as referencia, p.categoria as categoria "
                                    . "FROM producto p, talla_producto tp "
                                    . "WHERE p.referencia=tp.referencia_producto AND p.proceso='Bodega' $sqlcon"
                                    . "GROUP BY tp.referencia_producto ORDER BY p.fecha_proceso desc, p.id desc";
                            $query2 = $conn->query($sql2);
                            $row2 = mysqli_num_rows($query2);

                            $total_pages = ceil($row2 / $registro_por_pagina);

                            $pagina_antes = $total_pages - 5;
                            ?>

                            <style>


                                .paginacion ul {
                                    text-align: right;
                                }

                                .paginacion ul li {
                                    display:inline-block;
                                }

                                .paginacion ul li a {
                                    display:block;
                                    padding:5px 15px;
                                    color:white;
                                    background:black;
                                    text-decoration: none;
                                }

                                .paginacion ul li a:hover {
                                    background-color: #907510;
                                    color:#fff;
                                }

                                .paginacion ul li .active {
                                    background:#037E8C;
                                    font-weight:bold;
                                }
                            </style>

                            <section class="paginacion">
                                <ul class="" style="padding-left: 2px; padding-right: 2px;">
                                    <?php
                                    if ($pagina > 1) {
                                        ?>
                                        <li class="">
                                            <a class="page-link" href="prendas-bodega.php?pagina=<?php echo ($pagina - 1); ?>" aria-label="Previous">
                                                <span aria-hidden="true"><</span>
                                            </a>
                                        </li>
                                        <?php
                                    }

                                    if ($total_pages <= 7) {
                                        for ($i = 1; $i <= $total_pages; $i++) {

                                            if ($pagina == $i) {
                                                $color = "style='  background-color: #923EB9; color:#fff;'";
                                            } else {
                                                $color = "";
                                            }
                                            ?>
                                            <li class=""><a class="page-link" href="prendas-bodega.php?pagina=<?php echo $i; ?>" <?php echo$color; ?>><?php echo $i; ?></a></li>
                                            <?php
                                        }
                                    } else {

                                        if ($pagina > 5 and $pagina <= $pagina_antes) {

                                            $datos_iz = $pagina - 2;
                                            $datos_der = $pagina + 2;
                                            ?>
                                            <li class=""><a class="page-link" href="prendas-bodega.php?pagina=1">1</a></li>
                                            <li class=""><a class="page-link" href="" style="pointer-events: none;">...</a></li>
                                            <?php
                                            for ($i = $datos_iz; $i <= $datos_der; $i++) {

                                                if ($pagina == $i) {
                                                    $color = "style='  background-color: #907510; color:#fff;'";
                                                } else {
                                                    $color = "";
                                                }
                                                ?>
                                                <li class=""><a class="page-link" href="prendas-bodega.php?pagina=<?php echo $i; ?>" <?php echo$color; ?>><?php echo $i; ?></a></li>
                                                <?php
                                            }
                                            ?>
                                            <li class=""><a class="page-link" href="" style="pointer-events: none;">...</a></li>
                                            <li class=""><a class="page-link" href="prendas-bodega.php?pagina=<?php echo $total_pages; ?>"><?php echo $total_pages; ?></a></li>

                                            <?php
                                        } elseif ($pagina < 6) {

                                            for ($i = 1; $i <= 6; $i++) {

                                                if ($pagina == $i) {
                                                    $color = "style='  background-color: #907510; color:#fff;'";
                                                } else {
                                                    $color = "";
                                                }
                                                ?>

                                                <li class=""><a class="page-link" href="prendas-bodega.php?pagina=<?php echo $i; ?>" <?php echo $color; ?>><?php echo $i; ?></a></li>
                                                <?php
                                            }
                                            ?>
                                            <li class=""><a class="page-link" href="" style="pointer-events: none;">...</a></li>
                                            <li class=""><a class="page-link" href="prendas-bodega.php?pagina=<?php echo $total_pages; ?>"><?php echo $total_pages; ?></a></li>

                                            <?php
                                        } elseif ($pagina > $pagina_antes) {
                                            ?>
                                            <li class=""><a class="page-link" href="prendas-bodega.php?pagina=1">1</a></li>
                                            <li class=""><a class="page-link" href="" style="pointer-events: none;">...</a></li>
                                            <?php
                                            for ($i = $pagina_antes; $i <= $total_pages; $i++) {
                                                if ($pagina == $i) {
                                                    $color = "style='  background-color: #907510; color:#fff;'";
                                                } else {
                                                    $color = "";
                                                }
                                                ?>
                                                <li class=""><a class="page-link" href="prendas-bodega.php?pagina=<?php echo $i; ?>" <?php echo $color; ?>><?php echo $i; ?></a></li>
                                                <?php
                                            }
                                        }
                                    }

                                    if ($pagina < $total_pages) {
                                        ?>
                                        <li class="">
                                            <a class="page-link" href="prendas-bodega.php?pagina=<?php echo ($pagina + 1); ?>" aria-label="Next">
                                                <span aria-hidden="true">></span>
                                            </a>
                                        </li>
                                        <?php
                                    }
                                    ?>

                                </ul>
                            </section>



                        </div> 


                    </div>




                </div>
            </div>
            <!--end page content wrapper-->

            <?php echo include '../general/footer.php'; ?>

        </div>
        <!--end wrapper-->
        <?php echo include '../general/libreria-js.php'; ?>
    </body>
</html>