<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';

if (isset($_GET['year'])) {
    $year = $_GET['year'];
} else {
    $year = date('Y');
}

include './recaudo-grafico-mes.php';
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">


                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="../inicio/inicio.php"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">Inicio</li>
                        </ol>
                    </nav>

                    <div class="row">
                        <div class="col-12 col-sm-9">
                            <div class="card radius-10 w-100">
                                <div class="card-body">
                                    <div class="row">


                                        <div class="col-sm-4 mt-2">
                                            <div class="card radius-10 shadow-none mb-0 bg-gradient-success">
                                                <a href="../inventario/inventario.php">
                                                    <div class="card-body text-white p-4">
                                                        <div class="d-flex align-items-center gap-3">
                                                            <div class="fs-6">
                                                                <i class="fa-solid fa-box-open"></i>
                                                            </div>
                                                            <h5 class="mb-0">Inventario</h5>
                                                            <?php
                                                            $sql2 = "SELECT SUM(cantidad) as suma_disponible FROM referencia_disponible";
                                                            $query2 = $conn->query($sql2);
                                                            $row2 = $query2->fetch_assoc();
                                                            ?>
                                                            <div class="ms-auto"><?php echo number_format($row2['suma_disponible'], 0); ?></div>
                                                        </div>
                                                    </div>
                                                </a>
                                            </div>
                                        </div>

                                        <div class="col-sm-4 mt-2">
                                            <div class="card radius-10 shadow-none mb-0 bg-gradient-royal">
                                                <a href="../producto/producto.php">
                                                    <div class="card-body text-white p-4">
                                                        <div class="d-flex align-items-center gap-3">
                                                            <div class="fs-6">
                                                                <i class="fab fa-product-hunt"></i>
                                                            </div>
                                                            <h5 class="mb-0">Productos</h5>

                                                            <?php
                                                            $sql4 = "SELECT COUNT(id) as contar_productos FROM producto";
                                                            $query4 = $conn->query($sql4);
                                                            $row4 = $query4->fetch_assoc();
                                                            ?>
                                                            <div class="ms-auto"><?php echo number_format($row4['contar_productos'], 0); ?></div>
                                                        </div>
                                                    </div>
                                                </a>
                                            </div>
                                        </div>
                                        <div class="col-sm-4 mt-2">
                                            <div class="card radius-10 shadow-none mb-0 bg-gradient-purple">
                                                <a href="../produccion/produccion.php">
                                                    <div class="card-body text-white p-4">
                                                        <div class="d-flex align-items-center gap-3">
                                                            <div class="fs-6">
                                                                <i class="far fa-hdd"></i>              
                                                            </div>
                                                            <h5 class="mb-0">Cargar produccion</h5>
                                                            <?php
                                                            $sql5 = "SELECT SUM(cantidad) as suma_produccion FROM referencia_produccion";
                                                            $query5 = $conn->query($sql5);
                                                            $row5 = $query5->fetch_assoc();
                                                            ?>
                                                            <div class="ms-auto"><?php echo number_format($row5['suma_produccion'], 0); ?></div>
                                                        </div>
                                                    </div>
                                                </a>
                                            </div>
                                        </div>
                                    </div>                                                                       
                                </div>
                            </div>






                        </div>

                        <div class="col-12 col-sm-3">
                            <div class="card radius-10 w-100">
                                <div class="card-body ">
                                    <h6 class="text-center"><b>REPORTES</b></h6>
                                    <hr>

                                    <ul class="list-group list-group-flush">
                                        <li class="list-group-item bg-transparent "><strong>TERCEROS</strong></li>
                                        <li class="list-group-item bg-transparent "><a href="rpt-kardex.php" class="text-dark">RPT - Kardex</a></li>
                                    </ul>


                                    <ul class="list-group list-group-flush">
                                        <li class="list-group-item bg-transparent "><strong>EMPLEADOS</strong></li>
                                        <li class="list-group-item bg-transparent "><a href="rpt-general-empleados.php?fecha_desde=<?php echo date('Y-m-d'); ?>&&fecha_hasta=<?php echo date('Y-m-d'); ?>" class="text-dark">RPT - Empleado</a></li>


                                    </ul>


                                    <ul class="list-group list-group-flush">
                                        <li class="list-group-item bg-transparent "><strong>MERCANCIA</strong></li>
                                        <li class="list-group-item bg-transparent "><a href="rpt-produccion.php" class="text-dark">RPT - Produccion</a></li>
                                        <li class="list-group-item bg-transparent "><a href="rpt-produccion-detalle.php" class="text-dark">RPT - Produccion por detalle</a></li>
                                    </ul>

                                    <ul class="list-group list-group-flush">
                                        <li class="list-group-item bg-transparent "><strong>SEGUIMINETO DE REFERENCIAS</strong></li>
                                        <li class="list-group-item bg-transparent "><a href="rpt-seguimiento-referencia-talla.php" class="text-dark">RPT - Seguimiento por talla</a></li>
                                    </ul>


                                </div>
                            </div><!-- end col -->
                        </div>

                    </div>

                  
                </div>

                <?php echo include '../general/footer.php'; ?>
            </div>
        </div>

        <?php echo include '../general/libreria-js.php'; ?>



    </body>
</html>