<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">

                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="#"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">Orden de pedido</li>
                        </ol>
                    </nav>


                    <div class="row">
                        <div class="col-xl-12 mx-auto">
                            <div class="card">
                                <div class="card-body">
                                    <h6 class="mb-0 text-uppercase">Orden de pedido</h6>
                                    <hr/>
                                    <div class="p-4 border rounded">
                                        <form class=" g-3 needs-validation" method="POST" action="script/venta-guardar.php">
                                            <input class="form-control inputcss"  type="text" required="" name="nombre_usuario"  value="<?php echo $rowusu['nombre']; ?>" hidden readonly>

                                            <div class="row">
                                                <div class="col-md-2">
                                                    <h6 class="mt-3">Datos facturacion:</h6>
                                                    <hr class="mt-0" style="border-top: 2px dotted black;">
                                                    <style>
                                                        .inputcss{
                                                            color: brown;
                                                            font-weight: 500;
                                                        }
                                                    </style>

                                                    <div class="row ">
                                                        <div class="col-md-12">
                                                            <label class="form-label" for="validationCustom01">Fecha:</label>
                                                            <input class="form-control inputcss"  type="date" required="" name="fecha" value="<?php echo $fecha = date("Y-m-d"); ?>" >
                                                            <div class="valid-feedback">Se ve bien!</div>
                                                            <div class="invalid-feedback">Por favor, seleccione un fecha para el pedido.</div>
                                                        </div>
                                                        <div class="col-md-12 mt-3">
                                                            <label class="form-label" for="validationCustom01">Nompre tercero:</label>
                                                            <select class="form-select choices-1 " id="validationCustom04" required="" name="nombre_tercero">
                                                                <option value="VARIOS">VARIOS</option>
                                                                <option disabled="" value="">Seleccione</option>
                                                                <?php
                                                                $sql6m = "SELECT * FROM tercero";
                                                                $query6m = $conn->query($sql6m);
                                                                if ($query6m->num_rows > 0) {
                                                                    while ($row6m = $query6m->fetch_assoc()) {
                                                                        ?>

                                                                        <option value="<?php echo $row6m['nombre'] ?>"><?php echo $row6m['nombre'] ?></option>
                                                                        <?php
                                                                    }
                                                                }
                                                                ?>
                                                            </select>
                                                            <div class="valid-feedback">Se ve bien!</div>
                                                            <div class="invalid-feedback">Por favor, seleccione un tipo de venta.</div>
                                                        </div>
                                                        <div class="col-md-12 mt-3">
                                                            <label class="form-label" for="validationCustom02">No Pedido:</label>
                                                            <input class="form-control inputcss "   type="text" required="" name="numero_pedido" value="Opcional">
                                                            <div class="valid-feedback">Se ve bien!</div>
                                                            <div class="invalid-feedback">Por favor, Digite un numero de pedido.</div>
                                                        </div>
                                                        <div class="col-md-12 mt-3">
                                                            <label class="form-label" for="validationCustom02">No Remision:</label>
                                                            <input class="form-control inputcss "   type="text" required="" name="numero_remision" value="Opcional">
                                                            <div class="valid-feedback">Se ve bien!</div>
                                                            <div class="invalid-feedback">Por favor, Digite un numero de remision.</div>
                                                        </div>                                       

                                                    </div>
                                                </div>


                                                <div class="col-md-6">
                                                    <h6 class="mt-3">Datos del cliente:</h6>
                                                    <hr class="mt-0" style="border-top: 2px dotted black;">
                                                    <div class="row ">
                                                        <div class="col-md-4">
                                                            <label class="form-label" for="validationCustom01">Cedula o Nit:</label>
                                                            <input class="form-control inputcss"   type="text" required="" name="cedula" placeholder="**********" value="No aplica"> 
                                                            <div class="valid-feedback">Se ve bien!</div>
                                                            <div class="invalid-feedback">Por favor, Digite una cedula valida de lo contrario rellene con "No aplica"</div>
                                                        </div>
                                                        <div class="col-md-8 ">
                                                            <label class="form-label" for="validationCustom02">Nombre cliente:</label>
                                                            <input class="form-control inputcss"   type="text" required="" name="nombre" placeholder="Nombres y apellidos" value="No aplica">
                                                            <div class="valid-feedback">Se ve bien!</div>
                                                            <div class="invalid-feedback">Por favor, Digite nombres y apellidos.</div>
                                                        </div>
                                                        <div class="col-md-12 mt-3">
                                                            <label class="form-label" for="validationCustom02">Dirección:</label>
                                                            <textarea class="form-control inputcss"   type="text" required="" name="direccion" placeholder="Cll, Av, Mz 0E-00E Barrio">No aplica</textarea>
                                                            <div class="valid-feedback">Se ve bien!</div>
                                                            <div class="invalid-feedback">Por favor, Digite la direccion del cliente.</div>
                                                        </div>
                                                        <div class="col-md-8 mt-3">
                                                            <label class="form-label" for="validationCustom02">Destino:</label>
                                                            <input class="form-control inputcss"  type="text" required="" name="destino" placeholder="Ciudad - Departamento" value="No aplica">
                                                            <div class="valid-feedback">Se ve bien!</div>
                                                            <div class="invalid-feedback">Por favor, Digite el destino.</div>
                                                        </div>
                                                        <div class="col-md-4 mt-3">
                                                            <label class="form-label" for="validationCustom02">Telefono:</label>
                                                            <input class="form-control inputcss"  type="text" required="" name="telefono" placeholder="5555555555 - 5555555555" value="No aplica">
                                                            <div class="valid-feedback">Se ve bien!</div>
                                                            <div class="invalid-feedback">Por favor, Digite uno o dos numero de contacto.</div>
                                                        </div>
                                                        <div class="col-md-12 mt-3">
                                                            <label class="form-label" for="validationCustom02">Correo:</label>
                                                            <input class="form-control inputcss" type="text" required="" name="correo" placeholder="alguien@example.com" value="No aplica">
                                                            <div class="valid-feedback">Se ve bien!</div>
                                                            <div class="invalid-feedback">Por favor, Digite un correo valido de lo contrario rellene con "No aplica".</div>
                                                        </div>
                                                    </div>
                                                </div>


                                                <div class="col-md-4">
                                                    <h6 class="mt-3">Datos de envio:</h6>
                                                    <hr class="mt-0" style="border-top: 2px dotted black;">
                                                    <div class="row ">
                                                        <div class="col-md-6">
                                                            <label class="form-label" for="validationCustom01">Transportadora:</label>
                                                            <select class="form-select choices-1 " id="validationCustom04" required="" name="tercero_transportadora">
                                                                <option value="No aplica">No aplica</option>
                                                                <option disabled="" value="">Seleccione</option>
                                                                <?php
                                                                $sql7m = "SELECT * FROM tercero WHERE rol='Transporte' AND nombre!='VARIO'";
                                                                $query7m = $conn->query($sql7m);
                                                                if ($query7m->num_rows > 0) {
                                                                    while ($row7m = $query7m->fetch_assoc()) {
                                                                        ?>

                                                                        <option value="<?php echo $row7m['nombre'] ?>"><?php echo $row7m['nombre'] ?></option>
                                                                        <?php
                                                                    }
                                                                }
                                                                ?>
                                                            </select>
                                                            <div class="valid-feedback">Se ve bien!</div>
                                                            <div class="invalid-feedback">Por favor, seleccione una transportadora.</div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <label class="form-label" for="validationCustom01">Recaudadora:</label>
                                                            <select class="form-select choices-1 " id="validationCustom04" required="" name="tercero_recaudadora">
                                                                <option value="No aplica">No aplica</option>
                                                                <option disabled="" value="">Seleccione</option>
                                                                <?php
                                                                $sql8m = "SELECT * FROM tercero WHERE rol='Recaudador' AND nombre!='VARIO'";
                                                                $query8m = $conn->query($sql8m);
                                                                if ($query8m->num_rows > 0) {
                                                                    while ($row8m = $query8m->fetch_assoc()) {
                                                                        ?>

                                                                        <option value="<?php echo $row8m['nombre'] ?>"><?php echo $row8m['nombre'] ?></option>
                                                                        <?php
                                                                    }
                                                                }
                                                                ?>
                                                            </select>
                                                            <div class="valid-feedback">Se ve bien!</div>
                                                            <div class="invalid-feedback">Por favor, seleccione una transportadora.</div>
                                                        </div>
                                                        <div class="col-md-6 mt-3">
                                                            <label class="form-label" for="validationCustom02">No Guia:</label>
                                                            <input class="form-control inputcss"  type="text" required="" name="numero_guia" value="Opcional">
                                                            <div class="valid-feedback">Se ve bien!</div>
                                                            <div class="invalid-feedback">Por favor, Digite un numero de guia.</div>
                                                        </div>
                                                        <div class="col-md-6 mt-3">
                                                            <label class="form-label"  for="validationCustom02">Flete cliente:</label>
                                                            <input class="form-control inputcss"  id="flete"  type="text" required="" name="flete_cliente" value="0" >
                                                            <div class="valid-feedback">Se ve bien!</div>
                                                            <div class="invalid-feedback">Por favor, Digite costo del flete a cargo del cliente.</div>
                                                        </div>
                                                        <div class="col-md-6 mt-3">
                                                            <label class="form-label" for="validationCustom02">Flete empresa:</label>
                                                            <input class="form-control inputcss" id="flete1"  type="text" required="" name="flete_empresa" value="0">
                                                            <div class="valid-feedback">Se ve bien!</div>
                                                            <div class="invalid-feedback">Por favor, Digite costo del flete a cargo de la empresa.</div>
                                                        </div>
                                                        <div class="col-md-6 mt-3">
                                                            <label class="form-label" for="validationCustom01">Caja | Flete empresa:</label>
                                                            <select class="form-select"  required="" name="caja_flete">                                           
                                                                <optgroup label="Cajas">
                                                                    <option value="No aplica">No aplica</option>

                                                                    <?php
                                                                    $sql5 = "SELECT * FROM caja ORDER BY nombre desc";
                                                                    $query5 = $conn->query($sql5);
                                                                    if ($query5->num_rows > 0) {
                                                                        while ($row5 = $query5->fetch_assoc()) {
                                                                            ?>
                                                                            <option class="text-sm" value="<?php echo $row5['nombre']; ?>"><?php echo $row5['nombre']; ?></option>
                                                                            <?php
                                                                        }
                                                                    }
                                                                    ?>
                                                                </optgroup>
                                                            </select>  
                                                            <div class="valid-feedback">Se ve bien!</div>
                                                            <div class="invalid-feedback">Por favor, seleccione un tipo de venta.</div>
                                                        </div> 
                                                        <div class="col-md-12 mt-3">
                                                            <label class="form-label" for="validationCustom02">Observación:</label>
                                                            <textarea class="form-control inputcss"   type="text" required="" name="observacion"  placeholder="Complemento para direccion u observacion">Sin comentarios</textarea>
                                                            <div class="valid-feedback">Se ve bien!</div>
                                                            <div class="invalid-feedback">Por favor, Digite una descripcion para la orden.</div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="row">
                                                <div class="col-md-4">
                                                    <h6 class="mt-3">Modo de pago:</h6>
                                                    <hr class="mt-0" style="border-top: 2px dotted black;">
                                                    <style>
                                                        .inputcss{
                                                            color: brown;
                                                            font-weight: 500;
                                                        }
                                                    </style>

                                                    <div class="row ">
                                                        <div class="col-md-12 mt-3">
                                                            <label class="form-label" for="validationCustom01">Modo de pago:</label>
                                                            <select class="form-select choices-1 " id="validationCustom04" required="" name="modo_pago">
                                                                 <option value="Credito">Credito</option>
                                                                <option value="Contado">Contado</option>
                                                                                                                           </select>
                                                            <div class="valid-feedback">Se ve bien!</div>
                                                            <div class="invalid-feedback">Por favor, seleccione un tipo de venta.</div>
                                                        </div>                                      

                                                    </div>
                                                </div>

                                                <div class="col-md-5">
                                                    <h6 class="mt-3">Abono para venta:</h6>
                                                    <hr class="mt-0" style="border-top: 2px dotted black;">
                                                    <style>
                                                        .inputcss{
                                                            color: brown;
                                                            font-weight: 500;
                                                        }
                                                    </style>

                                                    <div class="row ">
                                                        <div class="col-md-6 mt-3">
                                                            <label class="form-label" for="validationCustom01">Monto abono venta:</label>
                                                            <input class="form-control inputcss"  id="flete"  type="text" required="" name="abono_venta" value="0" >
                                                            <div class="valid-feedback">Se ve bien!</div>
                                                            <div class="invalid-feedback">Por favor, seleccione un tipo de venta.</div>
                                                        </div> 

                                                        <div class="col-md-6 mt-3">
                                                            <label class="form-label" for="validationCustom01">Caja | Abono venta:</label>
                                                            <select class="form-select"  required="" name="caja_abono_venta">   

                                                                <optgroup label="Cajas">
                                                                    <option value="No aplica">No aplica</option>

                                                                    <?php
                                                                    $sql6 = "SELECT * FROM caja ORDER BY nombre desc";
                                                                    $query6 = $conn->query($sql6);
                                                                    if ($query6->num_rows > 0) {
                                                                        while ($row6 = $query6->fetch_assoc()) {
                                                                            ?>
                                                                            <option class="text-sm" value="<?php echo $row6['nombre']; ?>"><?php echo $row6['nombre']; ?></option>
                                                                            <?php
                                                                        }
                                                                    }
                                                                    ?>
                                                                </optgroup>
                                                            </select>  
                                                            <div class="valid-feedback">Se ve bien!</div>
                                                            <div class="invalid-feedback">Por favor, seleccione un tipo de venta.</div>
                                                        </div> 

                                                    </div>
                                                </div>



                                                <div class="col-md-3">
                                                    <h6 class="mt-3">Abono para flete:</h6>
                                                    <hr class="mt-0" style="border-top: 2px dotted black;">
                                                    <style>
                                                        .inputcss{
                                                            color: brown;
                                                            font-weight: 500;
                                                        }
                                                    </style>

                                                  
                                                    <div class="row ">
                                                        <div class="col-md-6 mt-3">
                                                            <label class="form-label" for="validationCustom01">Monto abono flete:</label>
                                                            <input class="form-control inputcss"  id="flete"  type="text" required="" name="abono_flete" value="0" >
                                                            <div class="valid-feedback">Se ve bien!</div>
                                                            <div class="invalid-feedback">Por favor, digite monto.</div>
                                                        </div> 

                                                        <div class="col-md-6 mt-3">
                                                            <label class="form-label" for="validationCustom01">Caja | Abono flete:</label>
                                                            <select class="form-select"  required="" name="caja_abono_flete">   

                                                                <optgroup label="Cajas">
                                                                    <option value="No aplica">No aplica</option>

                                                                    <?php
                                                                    $sql6 = "SELECT * FROM caja ORDER BY nombre desc";
                                                                    $query6 = $conn->query($sql6);
                                                                    if ($query6->num_rows > 0) {
                                                                        while ($row6 = $query6->fetch_assoc()) {
                                                                            ?>
                                                                            <option class="text-sm" value="<?php echo $row6['nombre']; ?>"><?php echo $row6['nombre']; ?></option>
                                                                            <?php
                                                                        }
                                                                    }
                                                                    ?>
                                                                </optgroup>
                                                            </select>  
                                                            <div class="valid-feedback">Se ve bien!</div>
                                                            <div class="invalid-feedback">Por favor, seleccione destino.</div>
                                                        </div> 

                                                    </div>
                                                </div>

                                            </div>

                                            <hr class="bg-gray-400 my-4">
                                            <div class="row">
                                                <div class="col-md-12" style="text-align: right;">
                                                    <button class="btn btn-primary px-5 radius-30" type="submit">Continuar</button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end page content-->
                    </div>
                    <!--end page content wrapper-->



                    <?php echo include '../general/footer.php'; ?>
                </div>
            </div>
        </div>
        <!--end wrapper-->
        <?php echo include '../general/libreria-js.php'; ?>

        <script>
            //Tabla producto
            $(document).ready(function () {
                var table = $('#example2').DataTable({
                    lengthChange: false,
                    buttons: ['copy', 'excel', 'pdf', 'print'],
                    "order": false,
                });

                table.buttons().container()
                        .appendTo('#example2_wrapper .col-md-6:eq(0)');
            });

        </script>

    </body>
</html>