<?php
session_start();
require '../../../script/conexion.php';

ini_set('display_errors', 0);
error_reporting(E_ALL);

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit('Método no permitido');
}

function post($k, $default = '') {
    return trim($_POST[$k] ?? $default);
}

$cedula   = post('cedula');
$nombre   = post('nombre');
$correo   = post('correo');
$telefono = post('telefono');

$usuario  = post('usuario');
$clave    = post('clave');   // <-- se guarda tal cual llega
$rol      = post('rol');

$estado   = 'Activo';
$mostrar  = 'si';

/* ---------------- Validaciones ---------------- */
$errores = [];

if ($cedula === '') $errores[] = 'Falta cédula';
if ($nombre === '') $errores[] = 'Falta nombre';
if ($usuario === '') $errores[] = 'Falta usuario';
if ($clave === '')   $errores[] = 'Falta clave';
if ($rol === '')     $errores[] = 'Falta rol';

if ($correo !== '' && !filter_var($correo, FILTER_VALIDATE_EMAIL)) $errores[] = 'Correo inválido';
if ($telefono !== '' && !preg_match('/^[0-9+\s\-()]{7,20}$/', $telefono)) $errores[] = 'Teléfono inválido';

if ($errores) {
    http_response_code(400);
    exit('Error: ' . implode(', ', $errores));
}

try {
    $conn->begin_transaction();

    /* 1) Duplicados */
    $stmtDup = $conn->prepare("
        SELECT id, usuario, cedula, correo
        FROM usuario
        WHERE usuario = ?
           OR cedula = ?
           OR (correo <> '' AND correo = ?)
        LIMIT 1
    ");
    if (!$stmtDup) throw new Exception("Prepare duplicados: " . $conn->error);

    $stmtDup->bind_param("sss", $usuario, $cedula, $correo);
    $stmtDup->execute();
    $dup = $stmtDup->get_result()->fetch_assoc();
    $stmtDup->close();

    if ($dup) {
        $conn->rollback();
        header("Location: ../usuario.php?err=" . urlencode("Ya existe un usuario con esos datos"));
        exit;
    }

    /* 2) Insert seguro (clave en texto plano) */
    $stmtIns = $conn->prepare("
        INSERT INTO usuario
        (cedula, nombre, correo, telefono, usuario, clave, rol, estado, mostrar)
        VALUES (?,?,?,?,?,?,?,?,?)
    ");
    if (!$stmtIns) throw new Exception("Prepare insert: " . $conn->error);

    $stmtIns->bind_param(
        "sssssssss",
        $cedula,
        $nombre,
        $correo,
        $telefono,
        $usuario,
        $clave,   // <-- texto plano
        $rol,
        $estado,
        $mostrar
    );

    if (!$stmtIns->execute()) throw new Exception("Execute insert: " . $stmtIns->error);
    $stmtIns->close();

    $conn->commit();

    header("Location: ../usuario.php?ok=1");
    exit;

} catch (Exception $e) {
    $conn->rollback();
    http_response_code(500);
    exit("Error: " . $e->getMessage());
}
