<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';

$segmento = $_GET['segmento'];
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">

                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="#"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="segmento.php"> 
                                    Segmentos
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page"><?php echo $segmento; ?></li>
                        </ol>
                    </nav>


                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-sm-4">

                                </div>
                                <div class="col-sm-4 text-center">
                                    <h3><b>Segmento: <?php echo $segmento; ?></b></h3>

                                </div>
                                <div class="col-sm-4 text-end">
                                    <a href="#!" class="btn btn-primary px-5 radius-30" data-bs-toggle="modal" data-bs-target="#exampleModal" >
                                        Agregar adorno a talla
                                    </a> 
                                </div>
                            </div>
                            <!-- Modal -->
                            <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                <div class="modal-dialog modal-sm">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title card-heading" id="exampleModalLabel">Agregar medida de adorno</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                        </div>
                                        <form class=" g-3 needs-validation" novalidate="" method="POST" action="script/adorno-guardar.php">
                                            <input type="text" name="segmento" value="<?php echo $segmento; ?>" hidden="">
                                            <div class="modal-body ">
                                                <div class="row ">
                                                    <div class="col-md-12 mt-3">
                                                        <label class="form-label" for="validationCustom01">Talla</label>
                                                        <select class="form-select " id="validationCustom04" required="" name="talla">
                                                            <option selected="" disabled="" value="">Seleccione</option>
                                                            <?php
                                                            for ($i = 10; $i < 50; $i++) {
                                                                ?>
                                                                <option value="<?php echo $i ?>">Talla <?php echo $i ?></option>
                                                                <?php
                                                            }
                                                            ?>
                                                        </select>
                                                        <div class = "valid-feedback">Se ve bien!</div>
                                                        <div class = "invalid-feedback">Por favor, seleccione una talla.</div>
                                                    </div>
                                                    <div class="col-md-12 mt-3">
                                                        <label class="form-label" for="validationCustom01">Medida en <b>cm</b></label>
                                                        <input class="form-control " required="" name="cm" value="0">

                                                        <div class = "valid-feedback">Se ve bien!</div>
                                                        <div class = "invalid-feedback">Por favor, digite un dato.</div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                                                <button type="submit" class="btn btn-success" >Guardar</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>


                        </div>
                    </div>


                    <div class="row">
                        <div class="col-sm-3"></div>
                        <div class="col-sm-6">
                            <div class="card">
                                <div class="card-body">
                                    <h6 class="mb-0 text-uppercase">Vira o adorno por tallas    </h6>
                                    <hr/>
                                    <div class="table-responsive mt-2">
                                        <table class="table align-middle mb-0" id="example2" style="width: 100%;">
                                            <thead>
                                                <tr>
                                                    <th class="text-center">Talla</th>
                                                    <th class="text-center">cm</th>
                                                    <th class="text-center">Acciones</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                $sql = "SELECT * FROM adorno";
                                                $query = $conn->query($sql);
                                                if ($query->num_rows > 0) {
                                                    while ($row = $query->fetch_assoc()) {
                                                        ?>
                                                        <tr class="align-middle">
                                                            <td class="text-center" style="min-width: 125px;">
                                                                <strong><?php echo $row['talla']; ?></strong>
                                                            </td>
                                                            <td class="text-center" style="max-width: 120px">
                                                                <?php echo $row['cm']; ?> cm

                                                            </td>
                                                            <td class="text-center" style="max-width: 120px">
                                                                <a  href="#!" data-bs-toggle="modal" data-bs-target="#editar" class=""
                                                                    data-id="<?php echo $row['id']; ?>"
                                                                    data-segmento="<?php echo $row['referencia_segmento']; ?>"
                                                                    data-talla="<?php echo $row['talla']; ?>"
                                                                    data-cm="<?php echo $row['cm']; ?>">
                                                                    <i class="far fa-edit opacity-5 me-4 text-warning"></i>
                                                                </a>
                                                            </td>
                                                        </tr>
                                                        <?php
                                                    }
                                                }
                                                ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>

                    <?php echo include '../general/footer.php'; ?>
                </div>
            </div>
        </div>
        <!--end wrapper-->
        <?php echo include '../general/libreria-js.php'; ?>
        <div class="modal fade" id="editar" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-sm">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title card-heading" id="exampleModalLabel">Editar medida de adorno</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form class=" g-3 needs-validation" novalidate="" method="POST" action="script/adorno-editar.php">
                        <input class="form-control" type="text" required="" name="edit_id" id="edit_id" hidden="" >
                        <input class="form-control" type="text" required="" name="edit_segmento" id="edit_segmento"  hidden="">
                        <div class="modal-body ">
                            <div class="row ">
                                <div class="col-md-12 ">
                                    <label class="form-label" for="validationCustom01">Talla</label>
                                    <select class="form-select " id="edit_talla" required="" name="edit_talla">
                                        <option selected="" disabled="" value="">Seleccione</option>
                                        <?php
                                        for ($i = 10; $i < 50; $i++) {
                                            ?>
                                            <option value="<?php echo $i ?>">Talla <?php echo $i ?></option>
                                            <?php
                                        }
                                        ?>
                                    </select>
                                    <div class="valid-feedback">Se ve bien!</div>
                                    <div class="invalid-feedback">Por favor, introduzca un numero de cedula.</div>
                                </div>
                                <div class="col-md-12 mt-2">
                                    <label class="form-label" for="validationCustom02">cm</label>
                                    <input class="form-control" type="text" required="" name="edit_cm" id="edit_cm">
                                    <div class="valid-feedback">Se ve bien!</div>
                                    <div class="invalid-feedback">Por favor, introduzca un nombre de pila.</div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-danger radius-30"  name="eliminar"
                                    onclick="if (!confirm('Seguro deseas eliminar este registro?')) {
                                                return false

                                            }">Eliminar</button>
                            <button type="submit" class="btn btn-warning  radius-30" name="editar" >Guardar cambios</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <script>
            // PASO DE PARAMETROS EDITAR
            $('#editar').on('show.bs.modal', function (event) {
                var button = $(event.relatedTarget) // Button that triggered the modal

                var id = button.data('id')
                var segmento = button.data('segmento')
                var talla = button.data('talla')
                var cm = button.data('cm')

                $('#edit_id').val(id)
                $('#edit_segmento').val(segmento)
                $('#edit_talla').val(talla)
                $('#edit_cm').val(cm)
            });

        </script>

        <script>
            //Tabla producto
            $(document).ready(function () {
                var table = $('#example2').DataTable({
                    lengthChange: false,
                    buttons: ['copy', 'excel', 'pdf', 'print'],
                    "order": false,
                });
                table.buttons().container()
                        .appendTo('#example2_wrapper .col-md-6:eq(0)');
            })
                    ;

        </script>

    </body>
</html>