<?php
session_start();
require '../../../script/conexion.php';

ini_set('display_errors', 0);
error_reporting(E_ALL);

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit('Método no permitido');
}

function post($k, $default = '') {
    return trim($_POST[$k] ?? $default);
}

$nombre_usuario = post('nombre_usuario');

$fecha       = post('fecha');
$referencia  = post('referencia');
$talla       = post('talla');
$cantidad    = post('cantidad');
$movimiento  = post('movimiento');
$observacion = post('observacion', 'No aplica');

$precio_unidad = 0;
$tipo_novedad  = 'Novedad';

/* ---------------- Validaciones ---------------- */
$errores = [];

if ($nombre_usuario === '') $errores[] = 'Falta nombre_usuario';
if ($referencia === '')     $errores[] = 'Falta referencia';
if ($talla === '')          $errores[] = 'Falta talla';
if ($movimiento === '')     $errores[] = 'Falta movimiento';

$dt = DateTime::createFromFormat('Y-m-d', $fecha);
if (!$dt || $dt->format('Y-m-d') !== $fecha) $errores[] = 'Fecha inválida';

if ($cantidad === '' || !is_numeric($cantidad) || (int)$cantidad <= 0) {
    $errores[] = 'Cantidad inválida';
}
$cantidad_int = (int)$cantidad;

// normaliza movimiento
$movimiento = ucfirst(strtolower($movimiento)); // "Salida" / "Entrada"
if (!in_array($movimiento, ['Salida', 'Entrada'], true)) {
    $errores[] = 'Movimiento inválido (use Entrada o Salida)';
}

if ($errores) {
    http_response_code(400);
    exit('Error: ' . implode(', ', $errores));
}

/* ---------------- Stock (ARREGLA el bug) ---------------- */
// OJO: aquí antes usabas $referencia_producto (no existe). Debe ser $referencia.
$stmtStock = $conn->prepare("
    SELECT COALESCE(SUM(cantidad),0) AS disponible
    FROM referencia_disponible
    WHERE referencia_producto = ? AND talla = ?
");
if (!$stmtStock) {
    http_response_code(500);
    exit("Error prepare stock: " . $conn->error);
}
$stmtStock->bind_param("ss", $referencia, $talla);
$stmtStock->execute();
$resStock = $stmtStock->get_result();
$rowStock = $resStock->fetch_assoc();
$stmtStock->close();

$stock = (int)($rowStock['disponible'] ?? 0);

/* ---------------- Guardado ---------------- */
try {
    $conn->begin_transaction();

    // Si es salida, valida stock suficiente
    if ($movimiento === 'Salida' && $stock < $cantidad_int) {
        $conn->rollback();
        // Redirige con mensaje simple por GET (o usa session flash si tienes)
        header("Location: ../novedad.php?referencia=" . urlencode($referencia) . "&msg=stock_insuficiente");
        exit;
    }

    // Insert novedad (prepared)
    $stmt = $conn->prepare("
        INSERT INTO novedad
        (nombre_usuario, nombre_tercero, fecha, referencia_producto, talla, cantidad, precio_unidad, movimiento, observacion, tipo_novedad)
        VALUES (?, NULL, ?, ?, ?, ?, ?, ?, ?, ?)
    ");
    if (!$stmt) throw new Exception("Prepare novedad: " . $conn->error);

    $stmt->bind_param(
        "ssssissss",
        $nombre_usuario,
        $fecha,
        $referencia,
        $talla,
        $cantidad_int,
        $precio_unidad,
        $movimiento,
        $observacion,
        $tipo_novedad
    );

    if (!$stmt->execute()) throw new Exception("Execute novedad: " . $stmt->error);
    $stmt->close();

    // Actualización de referencia (tu clase)
    $class_referencia = $referencia;
    $class_talla = $talla;
    require '../../../clases/class-referencia.php';

    $conn->commit();

    // PRG redirect
    header("Location: ../novedad.php?referencia=" . urlencode($referencia));
    exit;

} catch (Exception $e) {
    $conn->rollback();
    http_response_code(500);
    exit("Error al guardar: " . $e->getMessage());
}
