<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';
include '../../clases/sistema_functions.php';

/*--------- filtros ----------*/
$referencia = trim($_GET['referencia'] ?? 'Todo');
$categoria  = trim($_GET['categoria']  ?? 'Todo');

$cond = [];
if ($referencia !== 'Todo') $cond[] = "p.referencia='" . $conn->real_escape_string($referencia) . "'";
if ($categoria  !== 'Todo') $cond[] = "p.categoria='"  . $conn->real_escape_string($categoria)  . "'";

$where = $cond ? 'WHERE ' . implode(' AND ', $cond) : '';

?>
<!doctype html>
<html lang="es" class="light-theme">

<head>
    <?php include '../general/libreria-css.php'; ?>
    <style>
        tr[data-href] {
            cursor: pointer
        }

        tr[data-href]:hover {
            background: #eef !important
        }
    </style>
</head>

<body>
    <div class="wrapper">
        <?php echo include '../general/menu.php'; ?>
        <div class="page-content-wrapper">
            <div class="page-content">

                <!-- Migas -->
                <div class="card mb-3">
                    <div class="card-body py-2">
                        <ol class="breadcrumb m-0 align-items-center">
                            <li class="breadcrumb-item"><a href="../inicio/inicio.php"><ion-icon name="home-outline"></ion-icon></a></li>
                            <li class="breadcrumb-item active">Productos</li>
                        </ol>
                    </div>
                </div>

                <!-- Filtros -->
                <div class="card mb-3">
                    <div class="card-body">
                        <form class="row gx-2 gy-1 align-items-end" method="GET" action="producto.php">
                            <!-- Referencia -->
                            <div class="col-sm-3">
    <label class="form-label">Referencia</label>
    <select name="referencia" class="form-select custom-select">
        <option value="Todo" <?= ($referencia === 'Todo') ? 'selected' : '' ?>>Todas</option>
        <option disabled></option>
        <?php
        $refSql = "SELECT DISTINCT referencia FROM producto";
        if ($categoria !== 'Todo') {
            $refSql .= " WHERE categoria='" . $conn->real_escape_string($categoria) . "'";
        }
        $refSql .= " ORDER BY referencia ASC";
        $rs = $conn->query($refSql);
        while ($r = $rs->fetch_assoc()) {
            $refVal = $r['referencia'];
            $sel = ($referencia === $refVal) ? 'selected' : '';
            echo '<option value="'.htmlspecialchars($refVal).'" '.$sel.'>'.htmlspecialchars($refVal).'</option>';
        }
        ?>
    </select>
</div>

                          <div class="col-sm-2">
    <label class="form-label">Categoría</label>
    <select name="categoria" class="form-select">
        <option value="Todo" <?= ($categoria === 'Todo') ? 'selected' : '' ?>>Todas</option>
        <option disabled></option>
        <?php
        $catSql = "SELECT DISTINCT categoria FROM producto";
        if ($referencia !== 'Todo') {
            $catSql .= " WHERE referencia='" . $conn->real_escape_string($referencia) . "'";
        }
        $catSql .= " ORDER BY categoria ASC";
        $rs = $conn->query($catSql);
        while ($c = $rs->fetch_assoc()) {
            $catVal = $c['categoria'];
            $sel = ($categoria === $catVal) ? 'selected' : '';
            echo '<option value="'.htmlspecialchars($catVal).'" '.$sel.'>'.htmlspecialchars($catVal).'</option>';
        }
        ?>
    </select>
</div>


                            <!-- Botones -->
                            <div class="col-auto">
                                <button class="btn btn-info" type="submit"><i class="fas fa-search"></i> Buscar</button>
                                <a href="producto.php" class="btn btn-secondary">Limpiar</a>
                            </div>
                            <div class="col-auto ms-auto">
                                <a href="producto-nuevo.php" class="btn btn-success"><i class="fas fa-plus-circle"></i> Nuevo producto</a>
                            </div>
                        </form>
                    </div>
                </div>

                <?php
               $porPag = 12;
$pag    = max(1, (int)($_GET['pagina'] ?? 1));
$ini    = ($pag - 1) * $porPag;

/* --------- consulta orden A-Z por referencia --------- */
$sql = "SELECT p.*
        FROM producto p $where
        ORDER BY p.referencia ASC, p.id DESC
        LIMIT $ini,$porPag";
$prod = $conn->query($sql);

                ?>

                <!-- Lista -->
                <div class="card">
                    <div class="card-body">
                        <h6 class="fw-semibold mb-3">Lista de productos</h6>

                        <div class="table-responsive">
                            <table class="table table-bordered  table-striped align-middle mb-0">
                                <thead class="table-secondary">
                                    <tr>
                                        <th class=" ">FOTO</th>
                                        <th class="text-center ">SEGMENTO</th>
                                        <th class="text-center ">COD</th>
                                        <th class=" ">REFERENCIA</th>
                                        <th class=" ">COLOR</th>
                                        <th class=" ">COLOR 2</th>
                                        <th class=" ">BICOLOR</th>
                                        <th class="text-center ">CATEGORIA</th>
                                        <th class="text-center ">CLASE</th>
                                        <th class="text-center ">PESO</th>
                                        <th class="text-center ">ESTADO</th>
                                        <th class="text-center ">BLOQUEADO?</th>
                                        <th class=" ">CANT.</th>
                                        <th class="text-center ">PRECIO UNIDAD</th>
                                        <th class="text-center ">TOTAL</th>
                                        <th class="text-center ">DETALLE</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $totalPag = 0;
                                    while ($row = $prod->fetch_assoc()):
                                        $cantRes = $conn->query("SELECT SUM(cantidad) AS c
                                                         FROM referencia_disponible
                                                         WHERE referencia_producto='" . $row['referencia'] . "'")
                                            ->fetch_assoc();
                                        $cant   = $cantRes['c'] ?? 0;

                                        $badge  = ($row['habilitado'] === 'Si')
                                            ? '<span class="badge bg-success">Habilitado</span>'
                                            : '<span class="badge bg-danger">Inhabilitado</span>';

                                        $badge_bloqueo  = ($row['bloqueo'] === 'Si')
                                            ? '<span class="badge bg-danger">Si</span>'
                                            : '<span class="badge bg-success">No</span>';

                                        $totalPag += $row['precio_venta'] * $cant;
                                    ?>
                                        <tr class="">
                                            <td class="p-0">
                                                <?php
                                                // Resuelve la ruta final: miniatura real o cámara por defecto
                                                $foto = ($row['foto1'] === 'NO APLICA')
                                                    ? '../../img/camara.jpg'
                                                    : '../../img-producto/' . $row['foto1'];
                                                ?>
                                                <img src="<?= $foto ?>"
                                                    class="foto-thumb"
                                                    style="width:100%;height:60px;object-fit:contain;cursor:pointer;"
                                                    data-foto="<?= $foto ?>"
                                                    data-bs-toggle="modal"
                                                    data-bs-target="#fotoModal"
                                                    alt="vista previa">
                                            </td>
                                            <td><?= $row['referencia_segmento'] ?></td>
                                            <td><?= $row['codigo'] ?></td>
                                            <td><?= $row['referencia'] ?></td>
                                            <td><?= $row['color'] ?></td>
                                            <td><?= $row['color2'] ?></td>
                                            <td><?= $row['bicolor'] ?></td>
                                            <td><?= $row['categoria'] ?></td>
                                            <td><?= $row['clase'] ?></td>
                                            <td><?= $row['peso'] ?></td>
                                            <td class="text-center"><?= $badge ?></td>
                                            <td class="text-center"><?= $badge_bloqueo ?></td>
                                            <td><?= number_format($cant, 0) ?></td>
                                            <td><?= moneda($row['precio_venta']) ?></td>
                                            <td><?= moneda($row['precio_venta'] * $cant) ?></td>

                                            <td class="text-center p-0">

                                                <!-- Botón normal (pestaña nueva) -->
                                                <a href="kardex.php?referencia=<?= $row['referencia'] ?>"
                                                    class="btn btn-info me-1">
                                                    <i class="fas fa-file-alt"></i> Detalle
                                                </a>

                                            </td>

                                        </tr>
                                    <?php endwhile; ?>
                                </tbody>
                            </table>
                        </div>

                       <?php
$totalReg = $conn->query("SELECT COUNT(*) AS t FROM producto p $where")->fetch_assoc()['t'];
$totalP   = (int) ceil($totalReg / $porPag);

$refQ = urlencode($referencia);
$catQ = urlencode($categoria);
?>

<nav class="mt-3">
    <ul class="pagination justify-content-end m-0">

        <!-- Anterior -->
        <?php if ($pag > 1): ?>
            <li class="page-item">
                <a class="page-link" href="?pagina=<?= $pag - 1 ?>&referencia=<?= $refQ ?>&categoria=<?= $catQ ?>">&laquo;</a>
            </li>
        <?php endif; ?>

        <?php
        $r = 3; // rango de páginas visibles
        $iniPag = max(1, $pag - $r);
        $finPag = min($totalP, $pag + $r);

        // Si no empieza en 1, mostramos 1 y "..."
        if ($iniPag > 1) {
            echo '<li class="page-item"><a class="page-link" href="?pagina=1&referencia=' . $refQ . '&categoria=' . $catQ . '">1</a></li>';
            if ($iniPag > 2) echo '<li class="page-item disabled"><span class="page-link">…</span></li>';
        }

        // Páginas del rango
        for ($i = $iniPag; $i <= $finPag; $i++) {
            $act = ($i == $pag) ? ' active' : '';
            echo '<li class="page-item' . $act . '"><a class="page-link" href="?pagina=' . $i . '&referencia=' . $refQ . '&categoria=' . $catQ . '">' . $i . '</a></li>';
        }

        // Si no termina en la última, mostramos "..." y la última
        if ($finPag < $totalP) {
            if ($finPag < $totalP - 1) echo '<li class="page-item disabled"><span class="page-link">…</span></li>';
            echo '<li class="page-item"><a class="page-link" href="?pagina=' . $totalP . '&referencia=' . $refQ . '&categoria=' . $catQ . '">' . $totalP . '</a></li>';
        }
        ?>

        <!-- Siguiente -->
        <?php if ($pag < $totalP): ?>
            <li class="page-item">
                <a class="page-link" href="?pagina=<?= $pag + 1 ?>&referencia=<?= $refQ ?>&categoria=<?= $catQ ?>">&raquo;</a>
            </li>
        <?php endif; ?>

    </ul>
</nav>


                    </div>
                </div>

                <?php echo include '../general/footer.php'; ?>
            </div>
        </div>
    </div>

    <?php echo include '../general/libreria-js.php'; ?>
    <script>
        document.querySelectorAll('tr[data-href]').forEach(tr => {
            tr.addEventListener('click', () => location.href = tr.dataset.href);
        });
    </script>




    <!-- Modal de imagen -->
    <div class="modal fade" id="fotoModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content bg-transparent border-0"> <!-- sin bordes -->
                <div class="modal-body p-0">
                    <img id="fotoModalImg" src="" class="img-fluid w-100 rounded-3" alt="Imagen ampliada">
                </div>
            </div>
        </div>
    </div>
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            document.querySelectorAll('.foto-thumb').forEach(thumb => {
                thumb.addEventListener('click', () => {
                    // Cambia dinámicamente la imagen grande
                    document.getElementById('fotoModalImg').src = thumb.dataset.foto;
                });
            });
        });
    </script>


    <script>
        document.addEventListener('DOMContentLoaded', () => {
            document.querySelectorAll('.btn-popup').forEach(btn => {
                btn.addEventListener('click', () => {
                    const url = btn.dataset.url;

                    /* Ajusta las medidas a tu gusto */
                    const opciones = [
                        'width=1100', // ancho
                        'height=800', // alto
                        'left=100', // posición opcional
                        'top=50',
                        'scrollbars=yes', // barras de desplazamiento
                        'resizable=yes', // permitir redimensionar
                        'noopener,noreferrer' // seguridad extra
                    ].join(',');

                    window.open(url, 'kardexPopup', opciones);
                });
            });
        });
    </script>


</body>

</html>