<?php
session_start();
require '../../../script/conexion.php';

ini_set('display_errors', 0);
error_reporting(E_ALL);

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit('Método no permitido');
}

function post($k, $default = '') {
    return trim($_POST[$k] ?? $default);
}

$id_produccion = post('id_produccion');
$referencia    = post('referencia_producto');
$talla         = post('talla');
$cantidad      = post('cantidad');

/* ---------------- Validaciones ---------------- */
$errores = [];

if ($id_produccion === '' || !ctype_digit($id_produccion) || (int)$id_produccion <= 0) $errores[] = 'id_produccion inválido';
if ($referencia === '') $errores[] = 'Falta referencia_producto';
if ($talla === '')      $errores[] = 'Falta talla';

if ($cantidad === '' || !is_numeric($cantidad) || (int)$cantidad <= 0) $errores[] = 'Cantidad inválida';
$cantidad_int = (int)$cantidad;

if ($errores) {
    http_response_code(400);
    exit('Error: ' . implode(', ', $errores));
}

$id_int = (int)$id_produccion;

try {
    $conn->begin_transaction();

    // (Opcional) verificar que exista la producción
    $stmtP = $conn->prepare("SELECT id FROM produccion WHERE id = ? LIMIT 1");
    if (!$stmtP) throw new Exception("Prepare produccion: " . $conn->error);
    $stmtP->bind_param("i", $id_int);
    $stmtP->execute();
    $existe = (bool)$stmtP->get_result()->fetch_assoc();
    $stmtP->close();
    if (!$existe) throw new Exception("La producción no existe");

    // Insert detalle (prepared)
    $stmtI = $conn->prepare("
        INSERT INTO produccion_detalle (id_produccion, referencia_producto, talla, cantidad)
        VALUES (?,?,?,?)
    ");
    if (!$stmtI) throw new Exception("Prepare insert: " . $conn->error);

    $stmtI->bind_param("issi", $id_int, $referencia, $talla, $cantidad_int);
    if (!$stmtI->execute()) throw new Exception("Execute insert: " . $stmtI->error);
    $stmtI->close();

    // Recalcular referencia
    $class_referencia = $referencia;
    $class_talla = $talla;
    require '../../../clases/class-referencia.php';

    $conn->commit();

    header("Location: ../produccion-detalle.php?id_produccion=" . $id_int
        . "&referencia_producto=" . urlencode($referencia)
    );
    exit;

} catch (Exception $e) {
    $conn->rollback();
    http_response_code(500);
    exit("Error: " . $e->getMessage());
}
