<?php
session_start();
require '../../../script/conexion.php';

ini_set('display_errors', 0);
error_reporting(E_ALL);

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit('Método no permitido');
}

function post($k, $default = '') {
    return trim($_POST[$k] ?? $default);
}

/* ---------------- Entradas ---------------- */
$nombre_usuario     = post('nombre_usuario');
$fecha              = post('fecha');
$numero_produccion  = post('numero_produccion'); // no se usa (se genera), lo dejo por compatibilidad
$nombre_maquina     = post('nombre_maquina');
$canon              = post('canon');
$nombre_tercero_1   = post('nombre_tercero_1');
$nombre_tercero_2_i = post('nombre_tercero_2');
$nombre_tercero_3_i = post('nombre_tercero_3');
$observacion        = post('observacion');
$estado             = 'Proceso';

/* ---------------- Validaciones ---------------- */
$errores = [];

if ($nombre_usuario === '')   $errores[] = 'Falta nombre_usuario';
if ($nombre_maquina === '')   $errores[] = 'Falta nombre_maquina';
if ($nombre_tercero_1 === '') $errores[] = 'Falta nombre_tercero_1';
if ($observacion === '')      $errores[] = 'Falta observacion';

$dt = DateTime::createFromFormat('Y-m-d', $fecha);
if (!$dt || $dt->format('Y-m-d') !== $fecha) $errores[] = 'Fecha inválida';

if ($canon === '' || !is_numeric($canon) || (float)$canon < 0) $errores[] = 'Canon inválido';
$canon_num = (float)$canon;

// Normalizar terceros opcionales
$nombre_tercero_2 = null;
$nombre_tercero_3 = null;

if ($nombre_tercero_2_i !== '' && strtoupper($nombre_tercero_2_i) !== 'NO APLICA') {
    $nombre_tercero_2 = $nombre_tercero_2_i;
}
if ($nombre_tercero_3_i !== '' && strtoupper($nombre_tercero_3_i) !== 'NO APLICA') {
    $nombre_tercero_3 = $nombre_tercero_3_i;
}

if ($errores) {
    http_response_code(400);
    exit('Error: ' . implode(', ', $errores));
}

try {
    $conn->begin_transaction();

    /* -------------------------------------------------------
       1) Generar consecutivo seguro (evita duplicados)
    ------------------------------------------------------- */
    $stmtMax = $conn->prepare("SELECT MAX(numero_produccion) AS mayor FROM produccion FOR UPDATE");
    if (!$stmtMax) throw new Exception("Prepare max: " . $conn->error);

    $stmtMax->execute();
    $resMax = $stmtMax->get_result();
    $rowMax = $resMax->fetch_assoc();
    $stmtMax->close();

    $ultimo = $rowMax['mayor'] ?? '';
    $num = $ultimo ? (int)preg_replace('/[^0-9]+/', '', $ultimo) : 0;
    $codigo = (string)($num + 1);

    /* -------------------------------------------------------
       2) Insertar produccion (prepared + NULL reales)
    ------------------------------------------------------- */
    $stmtIns = $conn->prepare("
        INSERT INTO produccion
        (nombre_usuario, fecha, numero_produccion, nombre_maquina, canon,
         nombre_tercero_1, nombre_tercero_2, nombre_tercero_3, observacion, estado)
        VALUES (?,?,?,?,?,?,?,?,?,?)
    ");
    if (!$stmtIns) throw new Exception("Prepare insert: " . $conn->error);

    // s s s s d s s s s s  (para NULL opcional, mysqli acepta null en bind_param)
    $stmtIns->bind_param(
        "ssssdsssss",
        $nombre_usuario,
        $fecha,
        $codigo,
        $nombre_maquina,
        $canon_num,
        $nombre_tercero_1,
        $nombre_tercero_2,
        $nombre_tercero_3,
        $observacion,
        $estado
    );

    if (!$stmtIns->execute()) throw new Exception("Execute insert: " . $stmtIns->error);
    $id_produccion = (int)$conn->insert_id;
    $stmtIns->close();

    $conn->commit();

    header("Location: ../produccion-detalle.php?id_produccion=" . $id_produccion);
    exit;

} catch (Exception $e) {
    $conn->rollback();
    http_response_code(500);
    exit("Error: " . $e->getMessage());
}
