<?php
session_start();
require '../../../script/conexion.php';

ini_set('display_errors', 0);
error_reporting(E_ALL);

/* Acción crítica: SOLO POST */
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit('Método no permitido');
}

function post($k, $default = '') {
    return trim($_POST[$k] ?? $default);
}

$id_produccion = post('id_produccion');
$estado        = post('estado');

/* ---------------- Validaciones ---------------- */
$errores = [];

if ($id_produccion === '' || !ctype_digit($id_produccion) || (int)$id_produccion <= 0) {
    $errores[] = 'id_produccion inválido';
}

$estados_validos = ['Proceso', 'Confirmado', 'Finalizado', 'Cancelado'];
if ($estado === '' || !in_array($estado, $estados_validos, true)) {
    $errores[] = 'Estado inválido';
}

if ($errores) {
    http_response_code(400);
    exit('Error: ' . implode(', ', $errores));
}

$id_int = (int)$id_produccion;

try {
    $conn->begin_transaction();

    /* 1) Verificar que exista la producción */
    $stmtChk = $conn->prepare("SELECT id FROM produccion WHERE id = ? LIMIT 1");
    if (!$stmtChk) throw new Exception("Prepare check: " . $conn->error);

    $stmtChk->bind_param("i", $id_int);
    $stmtChk->execute();
    $existe = (bool)$stmtChk->get_result()->fetch_assoc();
    $stmtChk->close();

    if (!$existe) {
        throw new Exception("La producción no existe");
    }

    /* 2) Actualizar encabezado */
    $stmt1 = $conn->prepare("UPDATE produccion SET estado = ? WHERE id = ?");
    if (!$stmt1) throw new Exception("Prepare update produccion: " . $conn->error);

    $stmt1->bind_param("si", $estado, $id_int);
    if (!$stmt1->execute()) throw new Exception("Execute update produccion: " . $stmt1->error);
    $stmt1->close();

    /* 3) Actualizar detalle (si tu tabla NO tiene columna estado, esto fallará)
          -> si no existe 'estado' en produccion_detalle, dime y lo ajusto
    */
    $stmt2 = $conn->prepare("UPDATE produccion_detalle SET estado = ? WHERE id_produccion = ?");
    if (!$stmt2) throw new Exception("Prepare update detalle: " . $conn->error);

    $stmt2->bind_param("si", $estado, $id_int);
    if (!$stmt2->execute()) throw new Exception("Execute update detalle: " . $stmt2->error);
    $stmt2->close();

    /* 4) Recalcular referencias afectadas */
    $stmt3 = $conn->prepare("
        SELECT DISTINCT referencia_producto, talla
        FROM produccion_detalle
        WHERE id_produccion = ?
    ");
    if (!$stmt3) throw new Exception("Prepare select detalle: " . $conn->error);

    $stmt3->bind_param("i", $id_int);
    $stmt3->execute();
    $res3 = $stmt3->get_result();

    while ($row3 = $res3->fetch_assoc()) {
        $class_referencia = $row3['referencia_producto'];
        $class_talla = $row3['talla'];
        require '../../../clases/class-referencia.php';
    }
    $stmt3->close();

    $conn->commit();

    header("Location: ../produccion-detalle.php?id_produccion=" . $id_int);
    exit;

} catch (Exception $e) {
    $conn->rollback();
    http_response_code(500);
    exit("Error: " . $e->getMessage());
}
