<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';

$nombre_maquina = $_GET['nombre_maquina'];
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">

                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="#"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="produccion-panel.php">
                                    Panel produccion
                                </a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="produccion-orden.php">
                                    Ordenes produccion
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">Paso 1</li>
                        </ol>
                    </nav>

                    <div class="card">
                        <div class="card-body">
                            <h4 class="text-center"><b>GENERAR ORDEN DE PRODUCCION</b></h4>
                        </div>
                    </div>

                    <style>
                        #hover_enlace:hover{
                            box-shadow: 0px 0px 20px 0px #3C3D6B;
                        }

                    </style>                    

                    <div class="row mb-2">
                        <div class="col-sm-4">
                            <a href="#">
                                <div class="alert alert-success fade show mb-0 ">
                                    <strong class="alert-heading">PASO 1:</strong> Selecione maquina a trabajar.
                                </div>
                            </a>
                        </div>
                        <div class="col-sm-4">
                            <a href="#">
                                <div class="alert alert-success fade show mb-0 ">
                                    <strong class="alert-heading">PASO 2:</strong> Seleccione color.
                                </div>
                            </a>
                        </div>
                        <div class="col-sm-4">
                            <a href="#">
                                <div class="alert alert-warning fade show mb-0 ">
                                    <strong class="alert-heading">PASO 3:</strong> Imprimir ventas seleccionadas.
                                </div>
                            </a>
                        </div>
                    </div>




                    <div class="card radius-10 w-100">
                        <div class="card-body">


                            <h4><?php echo $nombre_maquina; ?></h4>
                            <?php
                            $sql1 = "SELECT * FROM maquina_material WHERE nombre_maquina='$nombre_maquina' ";
                            $query1 = $conn->query($sql1);
                            if ($query1->num_rows > 0) {
                                while ($row1 = $query1->fetch_assoc()) {
                                    echo $row1['nombre_categoria'];
                                }
                            }
                            ?>
                            <hr>

                            <div class="row">

                                <div class="col-4 mt-2"  >

                                    <div class="row">
                                        <?php
                                        $sql = "SELECT nombre_categoria as categoria FROM maquina_material WHERE nombre_maquina='$nombre_maquina' ";
                                        $query = $conn->query($sql);
                                        if ($query->num_rows > 0) {
                                            while ($row = $query->fetch_assoc()) {
                                                ?>

                                                <div class="col-12 mt-2"  >
                                                    <div class="card radius-10  mb-0 " style="box-shadow: 0px 1px 5px 2px #EAE6E6; border-radius: 15px;">
                                                        <a href="produccion-categoria.php?nombre_categoria=<?php echo $row['categoria']; ?>" id="hover_enlace" style="border-radius: 15px;">
                                                            <div class="card-body ">
                                                                <div class="d-flex align-items-center gap-3">

                                                                    <h5 class="mb-0 text-dark"><?php echo $row['categoria']; ?></h5>

                                                                    <div class="ms-auto"> </div>
                                                                </div>


                                                                <hr class="">

                                                                <ul class="list-unstyled mb-0 categories-list">

                                                                    <?php
                                                                    $pendiente_categoria = 0;

                                                                    $sql1 = "SELECT p.referencia, p.categoria, p.color "
                                                                            . "FROM referencia_produccion rp, producto p "
                                                                            . "WHERE p.referencia=rp.referencia_producto AND p.categoria='" . $row['categoria'] . "' GROUP BY p.color ORDER BY p.color asc";
                                                                    $query1 = $conn->query($sql1);
                                                                    if ($query1->num_rows > 0) {
                                                                        while ($row1 = $query1->fetch_assoc()) {

                                                                            $sql2 = "SELECT SUM(rp.cantidad) as cantidad_produccion "
                                                                                    . "FROM referencia_produccion rp, producto p "
                                                                                    . "WHERE p.referencia=rp.referencia_producto AND p.categoria='" . $row['categoria'] . "' AND p.color='" . $row1['color'] . "'";
                                                                            $query2 = $conn->query($sql2);
                                                                            $row2 = $query2->fetch_assoc();
                                                                            ?>

                                                                            <li>
                                                                                <span><?php echo $row1['color']; ?> <span class="float-end badge rounded-pill bg-primary"><?php echo $row2['cantidad_produccion']; ?></span></span>
                                                                            </li>

                                                                            <?php
                                                                            $pendiente_categoria += $row2['cantidad_produccion'];
                                                                        }
                                                                    }
                                                                    ?>
                                                                </ul>

                                                                <hr>
                                                                <div class="">
                                                                    <ul class="list-unstyled mb-0 categories-list">
                                                                        <li>
                                                                            <span><b>TOTAL</b> <span class="float-end badge rounded-pill bg-primary"><?php echo $pendiente_categoria; ?></span></span>
                                                                        </li>
                                                                    </ul>
                                                                </div>
                                                            </div>

                                                        </a>
                                                    </div>
                                                </div>
                                                <?php
                                            }
                                        }
                                        ?>
                                    </div>
                                </div>

                                <div class="col-8 mt-2"  >

                                    
                                    
                                    
                                    
                                </div>


                            </div>
                        </div>
                    </div>

                    <?php echo include '../general/footer.php'; ?>
                </div>
            </div>
        </div>
        <!--end wrapper-->
        <?php echo include '../general/libreria-js.php'; ?>

        <script>
            $('.single-select-producto').select2({
                theme: 'bootstrap4',
                width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
                placeholder: $(this).data('placeholder'),
                allowClear: Boolean($(this).data('allow-clear')),

            });

            $('#talla').select2({
                theme: 'bootstrap4',
                width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
                placeholder: $(this).data('placeholder'),
                allowClear: Boolean($(this).data('allow-clear')),

            });


            //Tabla producto
            $(document).ready(function () {
                var table = $('#example2').DataTable({
                    lengthChange: false,
                    buttons: ['copy', 'excel', 'pdf', 'print'],
                    "order": false,
                });

                table.buttons().container()
                        .appendTo('#example2_wrapper .col-md-6:eq(0)');
            });

        </script>

    </body>
</html>