<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">

                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="../inicio/inicio.php"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="../produccion/produccion-panel.php"> 
                                    Panel de produccion
                                </a>
                            </li>
                            <li class="breadcrumb-item">
                                Orden de trabajo
                            </li>
                        </ol>
                    </nav>

                    <div class="card">
                        <div class="card-body text-center bg-primary text-white">
                            <h3><b>ORDENES DE TRABAJO</b></h3>
                        </div>
                    </div>

                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-sm-9">
                                    <h6 class="mb-0 text-uppercase"><b>LISTA DE ORDENES DE TRABAJO</b> 
                                    </h6>
                                </div>
                                <div class="col-sm-3 text-end">

                                </div>
                            </div>

                            <hr>

                            <style>
                                #hover_enlace:hover{
                                    color: purple;
                                    border-radius: 10px; 
                                    box-shadow: 0px 0px 10px 0px purple;
                                }

                            </style>

                            <div class=" mt-2" style="overflow: auto; ">
                                <table class="table align-middle mb-0 table-striped table-bordered" border="1" id="example2" style="">
                                    <thead class="">
                                        <tr class="bg-primary text-white">
                                            <th class="text-center" style="width: 8%;">FECHA</th>
                                            <th class="text-center ">No ORDEN</th>
                                            <th class="text-center ">USUARIO REGISTRO</th>
                                            <th class="">MAQUINA</th>
                                            <th class="text-center">PUESTOS</th>
                                            <th class="text-center">ENCARGADO</th>
                                            <th class="text-center">FECHA DESDE</th>
                                            <th class="text-center">FECHA HASTA</th>
                                            <th class="text-center ">ESTADO</th>
                                            <th class="text-center">DETALLE</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $sql = "SELECT * FROM orden_trabajo ORDER BY fecha desc, id desc";
                                        $query = $conn->query($sql);
                                        if ($query->num_rows > 0) {
                                            while ($row = $query->fetch_assoc()) {


                                                $sql1 = "SELECT * FROM orden_sugerencia WHERE id_orden_trabajo='" . $row['id'] . "' ";
                                                $query1 = $conn->query($sql1);
                                                $row1 = $query1->fetch_assoc();

                                                if (isset($row1['estado'])) {
                                                    $estado = $row1['estado'];
                                                } else {
                                                    $estado = 'Proceso';
                                                }
                                                ?>
                                                <tr class="align-middle" id="hover_enlace" >
                                                    <td class="text-center">
                                                        <?php echo date('d-m-Y', strtotime($row['fecha'])); ?>
                                                    </td>
                                                    <td class="text-center">
                                                        <b> <?php echo $row['numero_orden_trabajo']; ?></b>
                                                    </td>
                                                    <td class="text-center">
                                                        <?php echo $row['nombre_usuario']; ?>
                                                    </td>
                                                    <td class="">
                                                        <?php echo $row['nombre_maquina']; ?>
                                                    </td> 
                                                    <td class="text-center">
                                                        <?php echo $row['puestos']; ?>
                                                    </td> 
                                                    <td class="">
                                                        <?php echo $row['nombre_empleado']; ?>
                                                    </td>
                                                    <td class="text-center">
                                                        <?php echo date("h:i:s A", strtotime($row['hora_desde'])); ?>
                                                    </td>
                                                    <td class="text-center">
                                                        <?php echo date("h:i:s A", strtotime($row['hora_hasta'])); ?>
                                                    </td>

                                                    <td class="text-center">
                                                        <b><?php echo $estado; ?></b>
                                                    </td>
                                                    <td class="text-center">
                                                        <a href="orden-trabajo-detalle.php?id_orden_trabajo=<?php echo $row['id']; ?>"><i class="fa-solid fa-arrow-right-to-bracket fa-2x"></i></a>
                                                    </td>
                                                </tr>
                                                <?php
                                            }
                                        }
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <?php echo include '../general/footer.php'; ?>
            </div>
        </div>
        <!--end wrapper-->
        <?php echo include '../general/libreria-js.php'; ?>
        <script>
            //Tabla producto
            $(document).ready(function () {
                var table = $('#example2').DataTable({
                    lengthChange: false,
                    buttons: ['copy', 'excel', 'pdf', 'print'],
                    "order": false,
                    language: {
                        search: 'Buscar',
                        zeroRecords: 'No hay registros para mostrar.',
                        emptyTable: 'La tabla está vacia.',
                        info: "Mostrando _START_ de _END_ de _TOTAL_ Registros.",
                        infoFiltered: "(Filtrados de _MAX_ Registros.)",
                        paginate: {
                            first: 'Primero',
                            previous: 'Anterior',
                            next: 'Siguiente',
                            last: 'Último'
                        }
                    }
                });

                table.buttons().container()
                        .appendTo('#example2_wrapper .col-md-6:eq(0)');
            });

        </script>
    </body>
</html>