<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">

                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="#"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="produccion-panel.php">
                                    Panel produccion
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">Maquina</li>
                        </ol>
                    </nav>


                    <div class="card">
                        <div class="card-body">
                            <h4 class="text-center"><b>MAQUINA</b></h4>
                        </div>
                    </div>



                    <style>
                        #hover_enlace:hover{
                            box-shadow: 0px 0px 20px 0px #3C3D6B;
                        }

                    </style>

                    <div class="card radius-10 w-100">
                        <div class="card-body">

                            <div class="row">
                                <div class="col-sm-6">
                                    <h5><b>Maquina</b></h5>
                                </div>
                                <div class="col-sm-6">
                                    <a href="#!" class="btn btn-primary px-5 radius-30 float-end" data-bs-toggle="modal" data-bs-target="#agregar" >
                                        Nueva maquina
                                    </a> 

                                    <div class="modal fade text-start" id="agregar" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                        <div class="modal-dialog modal-xs">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title card-heading" id="exampleModalLabel">Formulario | Agregar maquina</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <form class=" g-3 needs-validation" method="POST" action="script/maquina-guardar.php">
                                                    <div class="modal-body ">
                                                        <div class="row">
                                                            <div class="col-md-3 mt-2">
                                                                <label>Identificador</label>
                                                                <input class="form-control" type="text" required="" name="identificador">
                                                            </div>
                                                            <div class="col-md-9 mt-2">
                                                                <label>Nombre</label>
                                                                <input class="form-control" type="text"  required="" name="nombre">
                                                            </div>
                                                            <div class="col-md-4 mt-2">
                                                                <label>Puestos</label>
                                                                <input class="form-control" type="text"  required="" name="puestos">
                                                            </div>
                                                            <div class="col-md-4 mt-2">
                                                                <label>Rotativa</label>
                                                                <select class="form-control"   required="" name="rotativa">
                                                                    <option value="Si">Si</option>
                                                                    <option value="No">No</option>
                                                                </select>
                                                            </div>
                                                            <div class="col-md-4 mt-2">
                                                                <label>Cañones</label>
                                                                <select class="form-control"   required="" name="canones" >
                                                                    <option value="" disabled="">Selecciones</option>
                                                                    <option value="1">1</option>
                                                                    <option value="2">2</option>
                                                                </select>
                                                            </div>
                                                            <div class="col-md-4 mt-2">
                                                                <label>Limite de puestos</label>
                                                                <input class="form-control" type="text"  required="" name="limite_puestos">

                                                            </div>
                                                            <div class="col-md-4 mt-2">
                                                                <label>Duo</label>
                                                                <select class="form-control"   required="" name="duo" >
                                                                    <option value="" disabled="">Selecciones</option>
                                                                    <option value="No">No</option>
                                                                    <option value="Si">Si</option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="submit" class="btn btn-success px-5 radius-30" >Guardar</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>


                                </div>
                            </div>

                            <hr>


                            <div class="row">

                                <?php
                                $sql = "SELECT * FROM maquina ";
                                $query = $conn->query($sql);
                                if ($query->num_rows > 0) {
                                    while ($row = $query->fetch_assoc()) {
                                        ?>
                                        <div class="col-4 mt-2"  >
                                            <div class="card radius-10  mb-0 bg-light-dark" style="box-shadow: 0px 1px 5px 2px #EAE6E6; border-radius: 15px;">
                                                <a href="maquina-detalle.php?id_maquina=<?php echo $row['id']; ?>" id="hover_enlace" style="border-radius: 15px;">
                                                    <div class="card-body ">
                                                        <div class="d-flex align-items-center gap-3">

                                                            <h5 class="mb-0 text-dark"># <?php echo $row['identificador']; ?> - <?php echo $row['nombre']; ?></h5>

                                                            <div class="ms-auto">

                                                                <i class="fa-solid fa-arrow-right-to-bracket fa-2x"></i>

                                                            </div>
                                                        </div>
                                                        <hr class="">

                                                        <div class="row ">
                                                            <div class="col-6 text-dark"  >
                                                                <h6><b>Detalle</b></h6>
                                                                <li><?php echo $row['puestos']; ?> Puestos</li>
                                                                <li><?php echo $row['canones']; ?> Cañones</li>
                                                                <li><?php echo $row['rotativa']; ?> Rotativa</li>
                                                            </div>
                                                            <div class="col-6 text-dark"  >
                                                                <h6><b>Material que trabaja</b></h6>

                                                                <?php
                                                                $sql7 = "SELECT * FROM maquina_material WHERE nombre_maquina='" . $row['id'] . "' ";
                                                                $query7 = $conn->query($sql7);
                                                                if ($query7->num_rows > 0) {
                                                                    while ($row7 = $query7->fetch_assoc()) {
                                                                        ?>
                                                                        <li><?php echo $row7['nombre_categoria']; ?></li>
                                                                        <?php
                                                                    }
                                                                }
                                                                ?>

                                                            </div>
                                                        </div>
                                                    </div>
                                                </a>
                                            </div>
                                        </div>

                                        <?php
                                    }
                                }
                                ?>
                            </div>
                        </div>
                    </div>

                    <?php echo include '../general/footer.php'; ?>
                </div>
            </div>
        </div>
        <!--end wrapper-->
        <?php echo include '../general/libreria-js.php'; ?>

        <script>
            $('.single-select-producto').select2({
                theme: 'bootstrap4',
                width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
                placeholder: $(this).data('placeholder'),
                allowClear: Boolean($(this).data('allow-clear')),

            });

            $('#talla').select2({
                theme: 'bootstrap4',
                width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
                placeholder: $(this).data('placeholder'),
                allowClear: Boolean($(this).data('allow-clear')),

            });


            //Tabla producto
            $(document).ready(function () {
                var table = $('#example2').DataTable({
                    lengthChange: false,
                    buttons: ['copy', 'excel', 'pdf', 'print'],
                    "order": false,
                });

                table.buttons().container()
                        .appendTo('#example2_wrapper .col-md-6:eq(0)');
            });

        </script>

    </body>
</html>