<?php
/**
 * pedido-talla-eliminar.php
 *
 * Elimina una línea (referencia + talla) de un pedido.
 * Seguridad: POST + CSRF + sentencias preparadas.
 */
session_start();
include '../../../script/conexion.php';

/* ─────────────── Validaciones ─────────────── */
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);          // Method Not Allowed
    exit('Método no permitido');
}

if (!hash_equals($_SESSION['csrf'] ?? '', $_POST['csrf'] ?? '')) {
    http_response_code(403);          // Forbidden
    exit('Token CSRF inválido');
}

$id_pedido           = isset($_POST['id_pedido'])           ? (int)$_POST['id_pedido'] : 0;
$referencia_producto = $_POST['referencia_producto']        ?? '';
$talla               = $_POST['talla']                      ?? '';

if ($id_pedido <= 0 || $referencia_producto === '' || $talla === '') {
    http_response_code(400);          // Bad Request
    exit('Parámetros incorrectos');
}

/* ─────────────── Transacción ─────────────── */
$conn->begin_transaction();

try {
    /* 1. Borra la línea del detalle */
    $stmt = $conn->prepare(
        "DELETE FROM pedido_detalle
               WHERE id_pedido = ?
                 AND referencia_producto = ?
                 AND talla = ?"
    );
    $stmt->bind_param('iss', $id_pedido, $referencia_producto, $talla);
    $stmt->execute();

    /* 2. Obtiene datos del pedido (para las clases auxiliares) */
    $stmt2 = $conn->prepare(
        "SELECT nombre_tercero FROM pedido WHERE id = ?"
    );
    $stmt2->bind_param('i', $id_pedido);
    $stmt2->execute();
    $rowPedido = $stmt2->get_result()->fetch_assoc();

    /* 3. Llama a las clases que actualizan inventario / cierres */
    $class_referencia           = $referencia_producto;
    $class_talla                = $talla;
    include '../../../clases/class-referencia.php';

    $class_nombre_tercero_cierre = $rowPedido['nombre_tercero'] ?? '';
    $class_referencia_cierre     = $referencia_producto;
    $class_talla_cierre          = $talla;
    include '../../../clases/class-cierre.php';

    $conn->commit();

    /* 4. Post/Redirect/Get */
    header("Location: ../pedido-detalle.php?id_pedido=$id_pedido");
    exit;

} catch (Throwable $e) {
    $conn->rollback();
    http_response_code(500);          // Internal Server Error
    echo "Error en la transacción: " . $e->getMessage();
}
