<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';

//
// 1) Preparo un array con TODOS los “pedidos FIFO” pendientes
//
$rows = [];

$sqlRef = "SELECT 
    nombre_tercero, 
    referencia_producto, 
    talla, 
    cantidad AS saldo 
  FROM referencia_despacho
  ORDER BY referencia_producto, talla, nombre_tercero
";
$resRef = mysqli_query($conn, $sqlRef);

while ($ref = mysqli_fetch_assoc($resRef)) {
    $tercero = $ref['nombre_tercero'];
    $prod    = $ref['referencia_producto'];
    $talla   = $ref['talla'];
    $saldo   = $ref['saldo'];

    // Tomo todos los pedidos de ese cliente/referencia/talla, del más antiguo al más reciente
    $sqlPed = "SELECT 
        p.id          AS id_pedido,
        p.fecha       AS fecha,
        p.numero_pedido AS numero_pedido,
        pd.cantidad   AS cantidad_pedida
      FROM pedido p
      JOIN pedido_detalle pd 
        ON p.id = pd.id_pedido
      WHERE p.nombre_tercero    = ?
        AND pd.referencia_producto = ?
        AND pd.talla             = ?
      ORDER BY p.fecha DESC
    ";
    $stmt = mysqli_prepare($conn, $sqlPed);
    mysqli_stmt_bind_param($stmt, "sss", $tercero, $prod, $talla);
    mysqli_stmt_execute($stmt);
    $resP = mysqli_stmt_get_result($stmt);

    // Reparto FIFO: voy acumulando hasta cubrir el saldo
    $acum = 0;
    while (($ped = mysqli_fetch_assoc($resP)) && $acum < $saldo) {
        $resta = $saldo - $acum;
        $take  = min($ped['cantidad_pedida'], $resta);
        $acum += $take;

        $rows[] = [
            'referencia'    => $prod,
            'talla'         => $talla,
            'cliente'       => $tercero,
            'id_pedido'     => $ped['id_pedido'],
            'numero_pedido'     => $ped['numero_pedido'],
            'fecha'         => $ped['fecha'],
            'cantidad_fifo' => $take
        ];
    }
}
?>
<!doctype html>
<html lang="en" class="light-theme">

<head>
    <?php include '../general/libreria-css.php'; ?>
    <link rel="stylesheet" href="../../assets/plugins/datatable/css/dataTables.bootstrap5.min.css">
</head>

<body>
    <div class="wrapper">
        <?php include '../general/menu.php'; ?>

        <div class="page-content-wrapper">
            <div class="page-content">

                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="../inicio/inicio.php"><ion-icon name="home-outline"></ion-icon></a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            RPT - PRIORIDAD DE DESPACHOS
                        </li>
                    </ol>
                </nav>

                <div class="card mb-3">
                    <div class="card-body text-center">
                        <h3><b>INFORME DE PRIORIDAD DE DESPACHO</b></h3>
                    </div>
                </div>

                <div class="card">
                    <div class="card-body">
                        <table id="tablaPrioridad" class="table table-striped table-bordered">
                            <thead class="table-secondary">
                                <tr>
                                    <th>Referencia</th>
                                    <th>Talla</th>
                                    <th>Cliente</th>
                                    <th>Pedido #</th>
                                    <th>Fecha</th>
                                    <th>Cant. a despachar</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($rows as $r): ?>
                                    <tr>
                                        <td><?= htmlspecialchars($r['referencia']) ?></td>
                                        <td><?= htmlspecialchars($r['talla']) ?></td>
                                        <td><?= htmlspecialchars($r['cliente']) ?></td>
                                        <td>
                                            <a href="../pedido/pedido-detalle.php?id_pedido=<?= $r['id_pedido'] ?>" target="_blank" class="btn btn-info">
                                               Ver detalle # <b><?= $r['numero_pedido'] ?></b>
                                            </a>
                                        </td>
                                        <td><?= $r['fecha'] ?></td>
                                        <td><?= $r['cantidad_fifo'] ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th colspan="5" class="text-end">Total pendientes:</th>
                                    <th></th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>

                <?php include '../general/footer.php'; ?>
            </div>
        </div>
    </div>

    <?php include '../general/libreria-js.php'; ?>


    <script>
        $(document).ready(function() {
            inicializarDataTable2('#tablaPrioridad', {
                footerCallback: function(row, data, start, end, display) {
                    var api = this.api();

                    var parseValue = function(value) {
                        if (typeof value === 'string') {
                            var limpio = value.replace(/\$/g, '').replace(/,/g, '').replace(/\./g, '');
                            return parseFloat(limpio) || 0;
                        }
                        return typeof value === 'number' ? value : 0;
                    };

                    var getTotal = function(columnIndex) {
                        return api
                            .column(columnIndex, {
                                search: 'applied'
                            })
                            .data()
                            .reduce(function(a, b) {
                                return parseValue(a) + parseValue(b);
                            }, 0);
                    };
                    var totalCol5 = getTotal(5);

                    var formatNumber = function(num) {
                        return num.toLocaleString('es-ES', {
                            minimumFractionDigits: 0,
                            maximumFractionDigits: 0
                        });
                    };

                    $(api.column(5).footer()).html(formatNumber(totalCol5));
                },

                initComplete: function() {
                    var api = this.api();

                    // Índices de las columnas a filtrar (puedes agregar más)
                    var columnasAFiltrar = [0, 2]; // Ejemplo: columnas 3 y 4

                    columnasAFiltrar.forEach(function(index) {
                        var column = api.column(index);

                        // Crear el <select>
                        var select = $('<select class="form-select"><option value="">Todos</option></select>')
                            .appendTo($(column.header()).empty()) // Vacía el header y agrega el select
                            .on('change', function() {
                                var val = $.fn.dataTable.util.escapeRegex($(this).val());
                                column.search(val ? '^' + val + '$' : '', true, false).draw();
                            });

                        // Llenar el <select> con valores únicos
                        column.data().unique().sort().each(function(d) {
                            select.append($('<option>').val(d).text(d));
                        });
                    });
                },

                buttons: [{
                    extend: 'excel',
                    text: '<a class="btn btn-success"><i class="fa-solid fa-file-excel text-white fa-2x"></i></a>',
                    className: 'btn btn-light',
                    customizeData: function(data) {
                        // Cambiar encabezados
                        if (data.header.length > 3) {
                            data.header[0] = "REFERENCIA";
                            data.header[2] = "TERCERO";
                        }

                        // Cambiar más encabezados si necesitas
                        // data.header[1] = "Otro nombre";

                        // Recorremos todas las filas
                        data.body.forEach(function(row, rowIndex) {
                            row.forEach(function(value, colIndex) {
                                if (typeof value === 'string') {
                                    // Conservar ceros a la izquierda (por ejemplo en referencias)
                                    // Aplica solo si el valor es numérico pero tiene ceros a la izquierda
                                    if (/^0[0-9]+/.test(value)) {
                                        data.body[rowIndex][colIndex] = "'" + value; // Forzar texto
                                    } else {
                                        // Limpieza general de números
                                        var cleanValue = value.replace(/\./g, '').replace(/,/g, '.');
                                        if (!isNaN(cleanValue) && cleanValue.trim() !== '') {
                                            data.body[rowIndex][colIndex] = parseFloat(cleanValue);
                                        }
                                    }
                                }
                            });
                        });
                    },
                    exportOptions: {
                        columns: ':not(.no-export)',
                        footer: true
                    }
                }],

                "order": [
                    [4, 'asc']
                ],

                // mostrar 50 filas por página al cargar
                "pageLength": 50,


                "columnDefs": [
                    //{"searchable": false, "targets": 1}, 

                    { // NUEVO: desactivar orden en col. 3 y 4
                        orderable: false, // o  "sortable": false  (alias)
                        targets: [0, 2]
                    }
                ],
            });


        });
    </script>
</body>

</html>