
<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">


                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="../inicio/inicio.php"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="consultar.php"> 
                                    Consultar
                                </a>
                            </li>
                            <li class="breadcrumb-item active">                     
                                Confirmar
                            </li> 
                        </ol>
                    </nav>



                    <!-- end page title -->
                    <style>
                        #hover_enlace:hover{
                            color: orange;
                            border-radius: 10px; border: #3fc3ee 1px solid;
                            box-shadow: 0px 0px 5px 0px #3fc3ee;
                        }

                    </style>

                    <div class="card bg-gradient-warning">
                        <div class="card-body">

                            <h3 class=""><b class="">PEDIDOS</b> <b class="float-end">PANEL DE IMPRESION</b></h3>
                        </div>
                    </div>

                    <!-- CONTENIDO DE PAGINA-->
                    <section class="mb-3 mb-lg-5">


                        <div class="card-box">
                            <hr class="" style="border-top: 2px dotted orange;">
                            <div class="row mb-2">
                                <div class="col-sm-4">
                                    <a href="consultar.php">
                                        <div class="alert alert-success fade show mb-0 ">
                                            <strong class="alert-heading">PASO 1:</strong> Selecionar ventas a imprimir.
                                        </div>
                                    </a>
                                </div>
                                <div class="col-sm-4">
                                    <a href="#">
                                        <div class="alert alert-success fade show mb-0 ">
                                            <strong class="alert-heading">PASO 2:</strong> Confirmar ventas a imprimir.
                                        </div>
                                    </a>
                                </div>
                                <div class="col-sm-4">
                                    <a href="impresion.php">
                                        <div class="alert alert-warning fade show mb-0 ">
                                            <strong class="alert-heading">PASO 3:</strong> Imprimir ventas seleccionadas.
                                        </div>
                                    </a>
                                </div>
                            </div>

                            <section class="mb-3 mb-lg-5">


                                <div class="card card-table mb-4">
                                    <div class="card-header">
                                        <a href="script/confirmacion-limpiar.php"
                                           onclick="if (!confirm('Seguro deseas quitar todo los registros?')) {
                                                       return false

                                                   }"
                                           class="btn  btn-secondary btn-sm">Limpiar</a>
                                    </div>

                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="table table-striped table-bordered" id="datatable1">
                                                <thead>
                                                    <tr class="bg-gradient-warning text-dark">
                                                        <th class="text-center p-1" >ID PEDIDO</th>
                                                        <th class="text-center p-1" >FECHA</th>
                                                        <th class="text-center p-1" >TERCERO</th>
                                                        <th class="text-center p-1" >NUMERO PEDIDO</th>
                                                        <th class="text-center p-1" >OBSERVACION</th>
                                                        <th class="text-center p-1" >TOTAL PARES</th>
                                                        <th class="text-center p-1" >ESTADO</th>
                                                        <th class="text-center p-1" >CARGAR PARA IMPRESION</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php
                                                    $sql = "SELECT * FROM pedido WHERE panel_impresion='Si'";
                                                    $query = $conn->query($sql);
                                                    if ($query->num_rows > 0) {
                                                        while ($row = $query->fetch_assoc()) {
                                                            ?>


                                                            <tr class="align-middle">
                                                                <td class="text-center">
                                                                    <strong>
                                                                        <a href="../pedido/pedido-detalle.php?id_pedido=<?php echo $row['id']; ?>" style="text-decoration: underline;" target="_blank" class="text-bayk">
                                                                            ODP-<?php echo $row['id']; ?>
                                                                        </a>
                                                                    </strong>
                                                                </td>
                                                                <td class="text-center">
                                                                    <?php echo $row['fecha'] ?>
                                                                </td>
                                                                <td>
                                                                    <?php echo $row['nombre_tercero']; ?>
                                                                </td>
                                                                <td class="text-center">
                                                                    <?php echo $row['numero_pedido']; ?>
                                                                </td>
                                                                <td class="">
                                                                    <?php echo $row['observacion']; ?>
                                                                </td>
                                                                <td class="text-center">

                                                                    <?php
                                                                    $sql1 = "SELECT SUM(cantidad) as cantidad FROM pedido_detalle WHERE id_pedido='" . $row['id'] . "'";
                                                                    $query1 = $conn->query($sql1);
                                                                    $row1 = $query1->fetch_assoc();
                                                                    ?>

                                                                    <?php echo $row1['cantidad']; ?>
                                                                </td>
                                                                <td class="text-center" style="min-width: 125px;">
                                                                    <?php
                                                                    if ($row['estado'] == 'Proceso') {
                                                                        $alert_text = 'text-white';
                                                                        $alert = 'bg-info';
                                                                    } elseif ($row['estado'] == 'Confirmado') {
                                                                        $alert_text = 'text-white';
                                                                        $alert = 'bg-pink';
                                                                    } elseif ($row['estado'] == 'Alistamiento') {
                                                                        $alert_text = 'text-white';
                                                                        $alert = 'bg-primary';
                                                                    } elseif ($row['estado'] == 'Enviado') {
                                                                        $alert_text = 'text-white';
                                                                        $alert = 'bg-warning';
                                                                    } elseif ($row['estado'] == 'Novedad') {
                                                                        $alert_text = 'text-white';
                                                                        $alert = 'bg-bronze';
                                                                    } elseif ($row['estado'] == 'Entregado') {
                                                                        $alert_text = 'text-white';
                                                                        $alert = 'bg-success';
                                                                    } elseif ($row['estado'] == 'Finalizado') {
                                                                        $alert_text = 'text-white';
                                                                        $alert = 'bg-primary';
                                                                    } elseif ($row['estado'] == 'Cancelado') {
                                                                        $alert_text = 'text-white';
                                                                        $alert = 'bg-secondary';
                                                                    } elseif ($row['estado'] == 'Devolucion') {
                                                                        $alert_text = 'text-white';
                                                                        $alert = 'bg-dark';
                                                                    } else {
                                                                        $text = 'text-dark';
                                                                    }
                                                                    ?>
                                                                    <span class="badge <?php echo $alert; ?>"><?php echo $row['estado']; ?></span>

                                                                </td>

                                                                <td class="text-center">
                                                                    <a href="script/confirmacion-quitar.php?id_pedido=<?php echo $row['id']; ?>"
                                                                       class="text-dark">

                                                                        <strong class="text-danger">
                                                                            Quitar
                                                                        </strong>
                                                                    </a>
                                                                </td>
                                                            </tr>

                                                            <?php
                                                        }
                                                    }
                                                    ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>


                                    <div class="row p-3">

                                        <div class="col-12 text-end">
                                            <a href="impresion.php" class="btn  btn-info">Continuar</a>
                                        </div>
                                    </div>

                                </div>



                            </section>


                        </div>
                    </section>


                </div><!-- end col -->
                <!-- end page content-->
            </div>
            <!--end page content wrapper-->

            <?php echo include '../general/footer.php'; ?>

        </div>
        <!--end wrapper-->
        <?php echo include '../general/libreria-js.php'; ?>

    </body>
</html>

