<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';

if (isset($_GET['referencia_producto'])) {
    $autofocus_fecha = '';
    $autofocus_talla = 'autofocus';
} else {
    $autofocus_fecha = 'autofocus';
    $autofocus_talla = '';
}
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">

                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="#"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">Devoluciones</li>
                        </ol>
                    </nav>


                    <div class="card">
                        <div class="card-body">
                            <h4 class="text-center"><b>DEVOLUCIONES</b></h4>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-xl-5 mx-auto">
                            <div class="card">
                                <div class="card-body">

                                    <h6 class="mb-0 text-uppercase">Nueva devolucion</h6>


                                    <hr/>
                                    <div class="p-4 border rounded">
                                        <form method="POST" action="script/devolucion-guardar.php" class="row g-3 needs-validation ">
                                            <input type="text" required="" name="nombre_usuario" value="<?php echo $rowusu['nombre']; ?>" hidden>
                                            <div class="col-md-4">
                                                <label class="form-label" for="validationCustom02">Fecha</label>
                                                <input class="form-control" id="validationCustom02" type="date" required="" name="fecha" value="<?php echo date('Y-m-d'); ?>" <?php echo $autofocus_fecha; ?>>
                                                <div class="valid-feedback">Se ve bien!</div>
                                                <div class="invalid-feedback">Por favor, digite el dato.</div>
                                            </div>
                                            <div class="col-md-8">
                                                <label class="form-label" for="validationCustom01">Nombre tercero</label>
                                                <select class="single-select" id="validationCustom04" required="" name="nombre_tercero">
                                                    <?php
                                                    if (isset($_GET['nombre_tercero'])) {
                                                        ?>
                                                        <option selected=""  value="<?php echo $_GET['nombre_tercero']; ?>"><?php echo $_GET['nombre_tercero']; ?></option>
                                                        <option value="">Seleccione</option>
                                                        <?php
                                                    } else {
                                                        ?>
                                                        <option selected=""  value="">Seleccione</option>
                                                        <?php
                                                    }
                                                    ?>
                                                    <?php
                                                    $sql1 = "SELECT * FROM tercero";
                                                    $query1 = $conn->query($sql1);
                                                    if ($query1->num_rows > 0) {
                                                        while ($row1 = $query1->fetch_assoc()) {
                                                            ?>

                                                            <option value="<?php echo $row1['nombre'] ?>"><?php echo $row1['nombre'] ?></option>
                                                            <?php
                                                        }
                                                    }
                                                    ?>
                                                </select>
                                                <div class="valid-feedback">Se ve bien!</div>
                                                <div class="invalid-feedback">Por favor, seleccione una opcion.</div>
                                            </div>

                                            <div class="col-md-12">
                                                <label class="form-label" for="validationCustom01">Referencias</label>

                                                <select class="single-select" required="" name="referencia_producto" autofocus="">
                                                    <?php
                                                    if (isset($_GET['referencia_producto'])) {
                                                        ?>
                                                        <option selected=""  value="<?php echo $_GET['referencia_producto']; ?>"><?php echo $_GET['referencia_producto']; ?></option>
                                                        <option value="">Referencias</option>
                                                        <?php
                                                    } else {
                                                        ?>
                                                        <option selected=""  value="">Referencias</option>
                                                        <?php
                                                    }
                                                    ?>
                                                    <?php
                                                    $sql2 = "SELECT * FROM producto WHERE Habilitado='Si'";
                                                    $query2 = $conn->query($sql2);
                                                    if ($query2->num_rows > 0) {
                                                        while ($row2 = $query2->fetch_assoc()) {
                                                            ?>

                                                            <option value="<?php echo $row2['referencia'] ?>"><?php echo $row2['referencia'] ?> - <?php echo $row2['categoria']; ?></option>
                                                            <?php
                                                        }
                                                    }
                                                    ?>
                                                </select>
                                                <div class="valid-feedback">Se ve bien!</div>
                                                <div class="invalid-feedback">Por favor, seleccione referencia.</div>
                                            </div>


                                            <div class="col-md-4">
                                                <label class="form-label" for="validationCustom01">Tallas</label>

                                                <select class="form-select " id="talla" required="" name="talla" <?php echo $autofocus_talla; ?>>
                                                    <option selected="" disabled="" value="">Tallas</option>
                                                    <?php
                                                    for ($i = 10; $i < 49; $i++) {
                                                        ?>
                                                        <option value="<?php echo $i ?>">Talla <?php echo $i ?></option>
                                                        <?php
                                                    }
                                                    ?>
                                                </select>
                                                <div class="valid-feedback">Se ve bien!</div>
                                                <div class="invalid-feedback">Por favor, seleccione talla.</div>
                                            </div>



                                            <div class="col-md-4">
                                                <label class="form-label" for="validationCustom01">Cantidad</label>

                                                <input class="form-control inputcss "   type="number" required="" name="cantidad" placeholder="cant." value="0">
                                                <div class="valid-feedback">Se ve bien!</div>
                                                <div class="invalid-feedback">Por favor, Digite cantidad de prendas.</div>
                                            </div>

                                            <div class="col-md-4">
                                                <label class="form-label" for="validationCustom01">Precio unidad</label>

                                                <input class="form-control inputcss "   type="number" required="" name="precio_unidad" placeholder="cant." value="0">
                                                <div class="valid-feedback">Se ve bien!</div>
                                                <div class="invalid-feedback">Por favor, Digite cantidad de prendas.</div>
                                            </div>

                                            <div class="col-md-12 mb-3">
                                                <label class="form-label" for="validationCustom02">Observacin</label>
                                                <textarea class="form-control" id="validationCustom02" type="text" required="" name="observacion">No aplica</textarea>
                                                <div class="valid-feedback">Se ve bien!</div>
                                                <div class="invalid-feedback">Por favor, digite el dato.</div>
                                            </div>
                                            <div class="col-12 text-end">
                                                <button class="btn btn-primary" type="submit">Guardar</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>



                    <div class="row">
                        <div class="col-xl-12">
                            <div class="card">
                                <div class="card-body">




                                    <?php
                                    $sqlcon = "";
                                    if (isset($_GET['filtro'])) {

                                        $referencia = $_GET['referencia'];
                                    } else {
                                        $referencia = 'Todo';
                                    }

                                    if (isset($_GET['referencia'])) {
                                        $referencia = $_GET['referencia'];
                                    } else {
                                        $referencia = 'Todo';
                                    }




                                    if ($referencia != 'Todo') {
                                        $sqlcon = " AND referencia_producto='" . $referencia . "' ";
                                    } else {
                                        $sqlcon = "";
                                    }
                                    ?>

                                    <div class="card">
                                        <div class="card-body">
                                            <div class="p-4 border rounded">
                                                <form method="GET" action="devolucion.php" class="  d-print-none">
                                                    <div class="row" style="">
                                                        <div class="col-6 col-sm-3">
                                                            <div class="form-group">
                                                                <label><strong>Referencia:</strong></label>
                                                                <select class="single-select" name="referencia" required>

                                                                    <?php
                                                                    if ($referencia != 'Todo') {
                                                                        ?>
                                                                        <option value="<?php echo $referencia; ?>"><?php echo $referencia; ?></option>
                                                                        <option value="" disabled=""></option>
                                                                        <option value="Todo">Todos</option>
                                                                        <?php
                                                                    } else {
                                                                        ?>
                                                                        <option value="Todo">Todos</option>
                                                                        <option value="" disabled=""></option>
                                                                        <?php
                                                                    }
                                                                    ?>
                                                                    <?php
                                                                    $sqlp = "SELECT referencia_producto FROM novedad where tipo_novedad='Devolucion' group by referencia_producto";
                                                                    $queryp = $conn->query($sqlp);
                                                                    if ($queryp->num_rows > 0) {
                                                                        while ($rowp = $queryp->fetch_assoc()) {
                                                                            ?>
                                                                            <option value="<?php echo $rowp['referencia_producto']; ?>"><?php echo $rowp['referencia_producto']; ?></option>

                                                                            <?php
                                                                        }
                                                                    }
                                                                    ?>

                                                                </select>  
                                                            </div>
                                                        </div>

                                                        <div class="col-5 col-sm-1 pt-3">
                                                            <div class="form-group">
                                                                <button class="btn btn-primary px-4 radius-30" type="submit" name="filtro">
                                                                    Filtrar
                                                                </button>
                                                            </div>
                                                        </div>
                                                        <div class="col-5 col-sm-1 pt-3">
                                                            <div class="form-group">
                                                                <a href="devolucion.php" class="btn btn-secondary px-2 radius-30" >
                                                                    Restablecer
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>


                                    <?php
                                    $registro_por_pagina = 10;
                                    $pagina = '';
                                    if (isset($_GET["pagina"])) {
                                        $pagina = $_GET["pagina"];
                                    } else {
                                        $pagina = 1;
                                    }

                                    $start_from = ($pagina - 1) * $registro_por_pagina;
                                    ?>

                                    <h6 class="mb-0 text-uppercase">LISTA DE DEVOLUCIONES</h6>
                                    <hr/>

                                    <style>
                                        #hover_enlace:hover{
                                            color: purple;
                                            border-radius: 10px;
                                            box-shadow: 0px 0px 10px 0px purple;
                                        }

                                    </style>

                                    <div class=" mt-2" style="overflow: auto;">
                                        <table class="table align-middle mb-0 table-striped" id="example2" style="width: 100%;">
                                            <thead class="">
                                                <tr class="bg-light-primary text-primary">
                                                    <th class="text-center ">Id</th>
                                                    <th class="text-center " style="width: 7%;">Fecha</th>
                                                    <th class=" ">Nombre tercero</th>
                                                    <th class="text-center">Referencia</th>
                                                    <th class="">color</th>
                                                    <th class="text-center">Talla</th>
                                                    <th class="text-center">Cant</th>
                                                    <th class="text-center">Precio unidad</th>
                                                    <th class="text-center">Observacion</th>
                                                    <th class="text-center">Acciones</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                $sql4 = "SELECT * FROM novedad WHERE tipo_novedad='Devolucion' $sqlcon ORDER BY fecha desc, id desc LIMIT $start_from, $registro_por_pagina";
                                                $query4 = $conn->query($sql4);
                                                if ($query4->num_rows > 0) {
                                                    while ($row4 = $query4->fetch_assoc()) {

                                                        $sql3 = "SELECT * FROM producto WHERE referencia='" . $row4['referencia_producto'] . "'";
                                                        $query3 = $conn->query($sql3);
                                                        $row3 = $query3->fetch_assoc();
                                                        ?>
                                                        <tr class="align-middle" id="hover_enlace" >
                                                            <td class="text-center">
                                                                <strong class="text-dark"><?php echo $row4['id']; ?></strong><br>
                                                            </td>
                                                            <td class="text-center">
                                                                <strong class="text-dark"><?php echo $row4['fecha']; ?></strong><br>
                                                            </td>
                                                            <td class="">
                                                                <?php echo $row4['nombre_tercero']; ?>
                                                            </td>         
                                                            <td class="">
                                                                <b class="text-primary"><?php echo $row4['referencia_producto']; ?></b>
                                                            </td>  
                                                            <td class="">
                                                                <?php echo $row3['color']; ?>
                                                            </td>
                                                            <td class="text-center">
                                                                <?php echo $row4['talla']; ?>
                                                            </td>
                                                            <td class="text-center">
                                                                <?php echo $row4['cantidad']; ?>
                                                            </td>
                                                            <td class="text-end">
                                                                <b class="">$</b> <?php echo number_format($row4['precio_unidad'], 0); ?>
                                                            </td>
                                                            <td class="">
                                                                <?php echo $row4['observacion']; ?>
                                                            </td>
                                                            <td class="text-center">
                                                                <a href="#" 
                                                                   data-bs-toggle="modal" data-bs-target="#editar<?php echo $row4['id']; ?>">
                                                                    <i class="far fa-edit opacity-5 me-4 text-warning"></i>
                                                                </a>


                                                                <div class="modal fade text-start text-dark" id="editar<?php echo $row4['id']; ?>" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                                                    <div class="modal-dialog modal-sm">
                                                                        <div class="modal-content">
                                                                            <div class="modal-header bg-warning">
                                                                                <h5 class="modal-title card-heading" id="exampleModalLabel">Editar</h5>
                                                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                                            </div>
                                                                            <form class="" method="POST" action="script/devolucion-editar.php">
                                                                                <div class="modal-body row">

                                                                                    <input type="text" name="id" value="<?php echo $row4['id'] ?>" parsley-trigger="change" required hidden=""
                                                                                           class="form-control" >
                                                                                    <div class="col-md-12">
                                                                                        <label class="form-label" for="validationCustom02">Fecha</label>
                                                                                        <input class="form-control" id="validationCustom02" type="date" required="" name="fecha"  value="<?php echo $row4['fecha']; ?>">
                                                                                        <div class="valid-feedback">Se ve bien!</div>
                                                                                        <div class="invalid-feedback">Por favor, digite el dato.</div>
                                                                                    </div>
                                                                                    <div class="col-md-12 mt-2">
                                                                                        <label class="form-label" for="validationCustom01">Nombre tercero</label>
                                                                                        <select class="form-control"  required="" name="nombre_tercero">

                                                                                            <option selected="" value="<?php echo $row4['nombre_tercero'] ?>"><?php echo $row4['nombre_tercero'] ?></option>
                                                                                            <option  disabled="" value="">Seleccione</option>
                                                                                            <?php
                                                                                            $sql1 = "SELECT * FROM tercero ORDER BY nombre asc";
                                                                                            $query1 = $conn->query($sql1);
                                                                                            if ($query1->num_rows > 0) {
                                                                                                while ($row1 = $query1->fetch_assoc()) {
                                                                                                    ?>

                                                                                                    <option value="<?php echo $row1['nombre'] ?>"><?php echo $row1['nombre'] ?></option>
                                                                                                    <?php
                                                                                                }
                                                                                            }
                                                                                            ?>
                                                                                        </select>
                                                                                        <div class="valid-feedback">Se ve bien!</div>
                                                                                        <div class="invalid-feedback">Por favor, seleccione una opcion.</div>
                                                                                    </div>

                                                                                    <div class="col-md-12 mt-2">
                                                                                        <label class="form-label" for="validationCustom01">Referencias</label>

                                                                                        <select class="form-control" required="" name="referencia_producto" autofocus="">
                                                                                            <option selected="" value="<?php echo $row4['referencia_producto'] ?>"><?php echo $row4['referencia_producto'] ?></option>
                                                                                            <option  disabled="" value="">Seleccione</option>
                                                                                            <?php
                                                                                            $sql2 = "SELECT * FROM producto WHERE Habilitado='Si'";
                                                                                            $query2 = $conn->query($sql2);
                                                                                            if ($query2->num_rows > 0) {
                                                                                                while ($row2 = $query2->fetch_assoc()) {
                                                                                                    ?>

                                                                                                    <option value="<?php echo $row2['referencia'] ?>"><?php echo $row2['referencia'] ?> - <?php echo $row2['categoria']; ?></option>
                                                                                                    <?php
                                                                                                }
                                                                                            }
                                                                                            ?>
                                                                                        </select>
                                                                                        <div class="valid-feedback">Se ve bien!</div>
                                                                                        <div class="invalid-feedback">Por favor, seleccione referencia.</div>
                                                                                    </div>


                                                                                    <div class="col-sm-6 mt-2">
                                                                                        <label class="form-label" for="validationCustom01">Tallas</label>

                                                                                        <select class="form-select " id="validationCustom04" required="" name="talla">
                                                                                            <option selected="" value="<?php echo $row4['talla'] ?>"><?php echo $row4['talla'] ?></option>
                                                                                            <option  disabled="" value="">Seleccione</option>
                                                                                            <?php
                                                                                            for ($i = 10; $i < 49; $i++) {
                                                                                                ?>
                                                                                                <option value="<?php echo $i ?>">Talla <?php echo $i ?></option>
                                                                                                <?php
                                                                                            }
                                                                                            ?>
                                                                                        </select>
                                                                                        <div class="valid-feedback">Se ve bien!</div>
                                                                                        <div class="invalid-feedback">Por favor, seleccione talla.</div>
                                                                                    </div>



                                                                                    <div class="col-sm-6 mt-2">
                                                                                        <label class="form-label" for="validationCustom01">Cantidad</label>

                                                                                        <input class="form-control inputcss "   type="number" required="" name="cantidad" placeholder="cant." value="<?php echo $row4['cantidad']; ?>">
                                                                                        <div class="valid-feedback">Se ve bien!</div>
                                                                                        <div class="invalid-feedback">Por favor, Digite cantidad de prendas.</div>
                                                                                    </div>

                                                                                    <div class="col-md-12 mt-2">
                                                                                        <label class="form-label" for="validationCustom01">Precio unidad</label>

                                                                                        <input class="form-control inputcss "   type="number" required="" name="precio_unidad" placeholder="cant." value="<?php echo $row4['precio_unidad']; ?>">
                                                                                        <div class="valid-feedback">Se ve bien!</div>
                                                                                        <div class="invalid-feedback">Por favor, Digite cantidad de prendas.</div>
                                                                                    </div>

                                                                                    <div class="col-md-12 mt-2">
                                                                                        <label class="form-label" for="validationCustom02">Observacin</label>
                                                                                        <textarea class="form-control" id="validationCustom02" type="text" required="" name="observacion"><?php echo $row4['observacion']; ?></textarea>
                                                                                        <div class="valid-feedback">Se ve bien!</div>
                                                                                        <div class="invalid-feedback">Por favor, digite el dato.</div>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="modal-footer">

                                                                                    <button type="submit" class="btn btn-warning" name="editar" >Guardar cambios</button>
                                                                                </div>
                                                                            </form>
                                                                        </div>
                                                                    </div>
                                                                </div>

                                                                <a href="#" 
                                                                   data-bs-toggle="modal" data-bs-target="#eliminar<?php echo $row4['id']; ?>">
                                                                    <i class="far fa-trash-alt opacity-5 me-4 text-danger"></i>
                                                                </a>

                                                                <div class="modal fade text-start text-dark" id="eliminar<?php echo $row4['id']; ?>" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                                                    <div class="modal-dialog modal-lg">
                                                                        <div class="modal-content">
                                                                            <div class="modal-header bg-danger">
                                                                                <h5 class="modal-title card-heading text-white" id="exampleModalLabel">Eliminar</h5>
                                                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                                            </div>
                                                                            <form class="" method="POST" action="script/devolucion-eliminar.php">
                                                                                <div class="modal-body row">

                                                                                    <input type="text" name="id" value="<?php echo $row4['id'] ?>" parsley-trigger="change" required hidden=""
                                                                                           class="form-control" >

                                                                                    <div class="col-md-12 mt-2">

                                                                                        <b>
                                                                                            Estas seguro que deseas eliminar este registro!
                                                                                        </b>

                                                                                    </div>
                                                                                </div>
                                                                                <div class="modal-footer">

                                                                                    <button type="submit" class="btn btn-danger" name="editar" >Eliminar</button>
                                                                                </div>
                                                                            </form>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        <?php
                                                    }
                                                }
                                                ?>
                                            </tbody>
                                        </table>
                                    </div>



                                    <?php
                                    $sql2 = "SELECT * FROM novedad where  tipo_novedad='Devolucion' $sqlcon ORDER BY fecha desc ";
                                    $query2 = $conn->query($sql2);
                                    $row2 = mysqli_num_rows($query2);

                                    $total_pages = ceil($row2 / $registro_por_pagina);

                                    $pagina_antes = $total_pages - 5;
                                    ?>

                                    <style>


                                        .paginacion ul {
                                            text-align: right;
                                        }

                                        .paginacion ul li {
                                            display:inline-block;
                                        }

                                        .paginacion ul li a {
                                            display:block;
                                            padding:5px 15px;
                                            color:purple;
                                            background:#F2F2F2;
                                            text-decoration: none;
                                        }

                                        .paginacion ul li a:hover {
                                            background-color: purple;
                                            color:#fff;
                                        }

                                        .paginacion ul li .active {
                                            background:#purple;
                                            font-weight:bold;
                                        }
                                    </style>


                                    <section class="paginacion mt-3">
                                        <ul class="" style="padding-left: 2px; padding-right: 2px;">
                                            <?php
                                            if ($pagina > 1) {
                                                ?>
                                                <li class="">
                                                    <a class="page-link" href="devolucion.php?pagina=<?php echo ($pagina - 1); ?>&&referencia=<?php echo $referencia; ?>" aria-label="Previous">
                                                        <span aria-hidden="true"><</span>
                                                    </a>
                                                </li>
                                                <?php
                                            }

                                            if ($total_pages <= 7) {
                                                for ($i = 1; $i <= $total_pages; $i++) {

                                                    if ($pagina == $i) {
                                                        $color = "style='  background-color: purple; color:#fff;'";
                                                    } else {
                                                        $color = "";
                                                    }
                                                    ?>
                                                    <li class=""><a class="page-link" href="devolucion.php?pagina=<?php echo $i; ?>&&referencia=<?php echo $referencia; ?>" <?php echo$color; ?>><?php echo $i; ?></a></li>
                                                    <?php
                                                }
                                            } else {

                                                if ($pagina > 5 and $pagina <= $pagina_antes) {

                                                    $datos_iz = $pagina - 2;
                                                    $datos_der = $pagina + 2;
                                                    ?>
                                                    <li class=""><a class="page-link" href="devolucion.php?pagina=1&&referencia=<?php echo $referencia; ?>">1</a></li>
                                                    <li class=""><a class="page-link" href="" style="pointer-events: none;">...</a></li>
                                                    <?php
                                                    for ($i = $datos_iz; $i <= $datos_der; $i++) {

                                                        if ($pagina == $i) {
                                                            $color = "style='  background-color: purple; color:#fff;'";
                                                        } else {
                                                            $color = "";
                                                        }
                                                        ?>
                                                        <li class=""><a class="page-link" href="devolucion.php?pagina=<?php echo $i; ?>&&referencia=<?php echo $referencia; ?>" <?php echo$color; ?>><?php echo $i; ?></a></li>
                                                        <?php
                                                    }
                                                    ?>
                                                    <li class=""><a class="page-link" href="" style="pointer-events: none;">...</a></li>
                                                    <li class=""><a class="page-link" href="devolucion.php?pagina=<?php echo $total_pages; ?>&&referencia=<?php echo $referencia; ?>"><?php echo $total_pages; ?></a></li>

                                                    <?php
                                                } elseif ($pagina < 6) {

                                                    for ($i = 1; $i <= 6; $i++) {

                                                        if ($pagina == $i) {
                                                            $color = "style='  background-color: purple; color:#fff;'";
                                                        } else {
                                                            $color = "";
                                                        }
                                                        ?>

                                                        <li class=""><a class="page-link" href="devolucion.php?pagina=<?php echo $i; ?>&&referencia=<?php echo $referencia; ?>" <?php echo $color; ?>><?php echo $i; ?></a></li>
                                                        <?php
                                                    }
                                                    ?>
                                                    <li class=""><a class="page-link" href="" style="pointer-events: none;">...</a></li>
                                                    <li class=""><a class="page-link" href="devolucion.php?pagina=<?php echo $total_pages; ?>&&referencia=<?php echo $referencia; ?>"><?php echo $total_pages; ?></a></li>

                                                    <?php
                                                } elseif ($pagina > $pagina_antes) {
                                                    ?>
                                                    <li class=""><a class="page-link" href="devolucion.php?pagina=1&&referencia=<?php echo $referencia; ?>">1</a></li>
                                                    <li class=""><a class="page-link" href="" style="pointer-events: none;">...</a></li>
                                                        <?php
                                                        for ($i = $pagina_antes; $i <= $total_pages; $i++) {
                                                            if ($pagina == $i) {
                                                                $color = "style='  background-color: purple; color:#fff;'";
                                                            } else {
                                                                $color = "";
                                                            }
                                                            ?>
                                                        <li class=""><a class="page-link" href="devolucion.php?pagina=<?php echo $i; ?>&&referencia=<?php echo $referencia; ?>" <?php echo $color; ?>><?php echo $i; ?></a></li>
                                                        <?php
                                                    }
                                                }
                                            }

                                            if ($pagina < $total_pages) {
                                                ?>
                                                <li class="">
                                                    <a class="page-link" href="devolucion.php?pagina=<?php echo ($pagina + 1); ?>&&referencia=<?php echo $referencia; ?>" aria-label="Next">
                                                        <span aria-hidden="true">></span>
                                                    </a>
                                                </li>
                                                <?php
                                            }
                                            ?>

                                        </ul>
                                    </section>


                                </div>
                            </div>

                        </div>
                        <!-- end page content-->
                    </div>
                    <!--end page content wrapper-->





                    <?php echo include '../general/footer.php'; ?>
                </div>
            </div>
        </div>
        <!--end wrapper-->
        <?php echo include '../general/libreria-js.php'; ?>

        <script>
            $('.single-select-producto').select2({
                theme: 'bootstrap4',
                width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
                placeholder: $(this).data('placeholder'),
                allowClear: Boolean($(this).data('allow-clear')),

            });

            $('#talla').select2({
                theme: 'bootstrap4',
                width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
                placeholder: $(this).data('placeholder'),
                allowClear: Boolean($(this).data('allow-clear')),

            });




        </script>

    </body>
</html>