<?php
session_start();
include '../../../script/conexion.php';

/* ─── 1. Solo POST + CSRF ─── */
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit('Método no permitido');
}
if (!hash_equals($_SESSION['csrf'] ?? '', $_POST['csrf'] ?? '')) {
    http_response_code(403);
    exit('Token CSRF inválido');
}

/* ─── 2. Valida y sanea datos ─── */
$id_despacho         = (int)($_POST['id_despacho']         ?? 0);
$referencia_producto =        $_POST['referencia_producto'] ?? '';
$talla               =        $_POST['talla']               ?? '';
$precio_unidad       = (float)($_POST['precio_unidad']       ?? 0);

if ($id_despacho<=0 || $referencia_producto==='' || $talla==='' || $precio_unidad<0) {
    http_response_code(400);
    exit('Parámetros incorrectos');
}

/* ─── 3. Elimina dentro de una transacción ─── */
$conn->begin_transaction();

try {
    /* A) Eliminar la línea */
    $stmt = $conn->prepare(
      "DELETE FROM despacho_detalle
            WHERE id_despacho = ?
              AND referencia_producto = ?
              AND talla = ?
              AND precio_unidad = ?"
    );
    $stmt->bind_param('issd', $id_despacho, $referencia_producto, $talla, $precio_unidad);
    $stmt->execute();

    /* B) Si no quedan líneas iguales, borra sus paquetes */
    $stmt2 = $conn->prepare(
      "SELECT COUNT(*) AS c
         FROM despacho_detalle
        WHERE id_despacho = ?
          AND referencia_producto = ?
          AND precio_unidad = ?"
    );
    $stmt2->bind_param('isd', $id_despacho, $referencia_producto, $precio_unidad);
    $stmt2->execute();
    $count = $stmt2->get_result()->fetch_assoc()['c'];

    if ($count == 0) {
        $stmt3 = $conn->prepare(
          "DELETE FROM despacho_paquete
                WHERE id_despacho = ?
                  AND referencia_producto = ?
                  AND precio_unidad = ?"
        );
        $stmt3->bind_param('isd', $id_despacho, $referencia_producto, $precio_unidad);
        $stmt3->execute();
    }

    /* C) Clases auxiliares (inventario / cierre) */
    $rowt = $conn->query("SELECT nombre_tercero FROM despacho WHERE id='$id_despacho'")
                 ->fetch_assoc();

    $class_referencia           = $referencia_producto;
    $class_talla                = $talla;
    include '../../../clases/class-referencia.php';

    $class_nombre_tercero_cierre = $rowt['nombre_tercero'];
    $class_referencia_cierre     = $referencia_producto;
    $class_talla_cierre          = $talla;
    include '../../../clases/class-cierre.php';

    $conn->commit();

    header("Location: ../despacho-detalle.php?id_despacho=$id_despacho");
    exit;

} catch (Throwable $e) {
    $conn->rollback();
    http_response_code(500);
    echo "Error: ".$e->getMessage();
}
