<?php
session_start();
require '../../../script/conexion.php';

ini_set('display_errors', 0);
error_reporting(E_ALL);

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit('Método no permitido');
}

function post($k, $default = '') {
    return trim($_POST[$k] ?? $default);
}

$id_despacho         = post('edit_id_despacho');
$referencia_producto = post('edit_referencia_producto');
$precio_unidad_old   = post('edit_precio_unidad');
$precio_nuevo_raw    = post('edit_precio_unidad_nuevo');

/* Normalizar precio nuevo (te llega con separadores) */
$precio_unidad_new = (float)preg_replace('/[^0-9.]+/', '', str_replace(',', '.', (string)$precio_nuevo_raw));

/* ---------------- Validaciones ---------------- */
$errores = [];

if ($id_despacho === '' || !ctype_digit($id_despacho) || (int)$id_despacho <= 0) $errores[] = 'id_despacho inválido';
if ($referencia_producto === '') $errores[] = 'Falta referencia_producto';

if ($precio_unidad_old === '' || !is_numeric($precio_unidad_old) || (float)$precio_unidad_old < 0) {
    $errores[] = 'precio_unidad (actual) inválido';
}
$precio_old = (float)$precio_unidad_old;

if ($precio_nuevo_raw === '' || !is_numeric(preg_replace('/[^0-9.]+/', '', str_replace(',', '.', (string)$precio_nuevo_raw))) || $precio_unidad_new < 0) {
    $errores[] = 'precio_unidad_nuevo inválido';
}

if ($errores) {
    http_response_code(400);
    exit('Error: ' . implode(', ', $errores));
}

$id_int = (int)$id_despacho;

try {
    $conn->begin_transaction();

    /* 1) Update despacho_detalle */
    $stmt1 = $conn->prepare("
        UPDATE despacho_detalle
        SET precio_unidad = ?
        WHERE id_despacho = ?
          AND referencia_producto = ?
          AND precio_unidad = ?
    ");
    if (!$stmt1) throw new Exception("Prepare update detalle: " . $conn->error);

    $stmt1->bind_param("disd", $precio_unidad_new, $id_int, $referencia_producto, $precio_old);
    if (!$stmt1->execute()) throw new Exception("Execute update detalle: " . $stmt1->error);
    $stmt1->close();

    /* 2) Update despacho_paquete (si existen filas) */
    // No necesitas COUNT: puedes actualizar directo, y si no hay filas afectadas no pasa nada.
    $stmt2 = $conn->prepare("
        UPDATE despacho_paquete
        SET precio_unidad = ?
        WHERE id_despacho = ?
          AND referencia_producto = ?
          AND precio_unidad = ?
    ");
    if (!$stmt2) throw new Exception("Prepare update paquete: " . $conn->error);

    $stmt2->bind_param("disd", $precio_unidad_new, $id_int, $referencia_producto, $precio_old);
    if (!$stmt2->execute()) throw new Exception("Execute update paquete: " . $stmt2->error);
    $stmt2->close();

    $conn->commit();

    // PRG redirect
    header("Location: ../despacho-detalle.php?id_despacho=" . $id_int);
    exit;

} catch (Exception $e) {
    $conn->rollback();
    http_response_code(500);
    exit("Error: " . $e->getMessage());
}
