<?php
session_start();
require '../../../script/conexion.php';

ini_set('display_errors', 0);
error_reporting(E_ALL);

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit('Método no permitido');
}

function post($k, $default = '') {
    return trim($_POST[$k] ?? $default);
}

$nombre_usuario   = post('nombre_usuario');
$fecha            = post('fecha');
$nombre_tercero   = post('nombre_tercero');
$numero_despacho  = post('numero_despacho');
$observacion      = post('observacion', 'No aplica');

/* ---------------- Validaciones ---------------- */
$errores = [];

if ($nombre_usuario === '')  $errores[] = 'Falta nombre_usuario';
if ($nombre_tercero === '')  $errores[] = 'Falta nombre_tercero';
if ($numero_despacho === '') $errores[] = 'Falta numero_despacho';

$dt = DateTime::createFromFormat('Y-m-d', $fecha);
if (!$dt || $dt->format('Y-m-d') !== $fecha) $errores[] = 'Fecha inválida';

if ($errores) {
    http_response_code(400);
    exit('Error: ' . implode(', ', $errores));
}

/* ---------------- Traer datos del tercero (seguro) ---------------- */
$stmtT = $conn->prepare("SELECT nit, nombre, direccion, ubicacion, telefono, correo FROM tercero WHERE nombre = ? LIMIT 1");
if (!$stmtT) {
    http_response_code(500);
    exit("Error prepare tercero: " . $conn->error);
}
$stmtT->bind_param("s", $nombre_tercero);
$stmtT->execute();
$resT = $stmtT->get_result();
$row3 = $resT->fetch_assoc();
$stmtT->close();

if (!$row3) {
    http_response_code(400);
    exit("Error: El tercero no existe en la tabla tercero");
}

$cedula    = $row3['nit'] ?? '';
$nombre    = $row3['nombre'] ?? '';
$direccion = $row3['direccion'] ?? '';
$destino   = $row3['ubicacion'] ?? '';
$telefono  = $row3['telefono'] ?? '';
$correo    = $row3['correo'] ?? '';

/* ---------------- Insert despacho ---------------- */
$estado = 'Proceso';
$total_despacho = 0;
$panel_impresion = 'No';
$documento_guia = 'No aplica';

try {
    $conn->begin_transaction();

    $stmt = $conn->prepare("
        INSERT INTO despacho
        (nombre_usuario, fecha, nombre_tercero, numero_despacho,
         cedula, nombre, direccion, destino, telefono, correo, observacion,
         estado, total_despacho, panel_impresion, documento_guia)
        VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)
    ");
    if (!$stmt) throw new Exception("Prepare despacho: " . $conn->error);

    // types: s s s s  s s s s s s s  s d s s
    $stmt->bind_param(
        "ssss" . "sssssss" . "sds" . "s",
        $nombre_usuario,
        $fecha,
        $nombre_tercero,
        $numero_despacho,
        $cedula,
        $nombre,
        $direccion,
        $destino,
        $telefono,
        $correo,
        $observacion,
        $estado,
        $total_despacho,
        $panel_impresion,
        $documento_guia
    );

    if (!$stmt->execute()) throw new Exception("Execute despacho: " . $stmt->error);

    $id_despacho = $conn->insert_id;
    $stmt->close();

    $conn->commit();

    // PRG redirect (evita duplicado por refresh)
    header("Location: ../despacho-detalle.php?id_despacho=" . (int)$id_despacho);
    exit;

} catch (Exception $e) {
    $conn->rollback();
    http_response_code(500);
    exit("Error al guardar: " . $e->getMessage());
}
