<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">

                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="#"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">Cruce de cuentas</li>
                        </ol>
                    </nav>



                    <div class="card">
                        <div class="card-body">

                            <div class="row">
                                <div class="col-sm-8">
                                </div>
                                <div class="col-sm-4 text-end">
                                    <a href="#!" class="btn btn-primary px-5 radius-30" data-bs-toggle="modal" data-bs-target="#agregar" >
                                        Nuevo cruce <i class="fas fa-plus-circle"></i>
                                    </a>

                                    <div class="modal fade text-start" id="agregar" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                        <div class="modal-dialog modal-sm">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title card-heading" id="exampleModalLabel">Formulario | Agregar cruce</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <form class="" method="POST" action="script/cruce-guardar.php">
                                                    <div class="modal-body ">
                                                        <div class="row">
                                                            <div class="col-md-12 mb-3">
                                                                <label><strong>Fecha</strong></label>
                                                                <input class="form-control" type="date" required="" name="fecha">
                                                            </div>
                                                            <div class="col-md-12 mb-3">
                                                                <label><strong>Tercero origen</strong></label>
                                                                <select class="form-select"  required="" name="tercero_origen">                                           
                                                                    <option selected="" disabled="" value="">Seleccione</option>
                                                                    <?php
                                                                    $sql1 = "SELECT * FROM tercero";
                                                                    $query1 = $conn->query($sql1);
                                                                    if ($query1->num_rows > 0) {
                                                                        while ($row1 = $query1->fetch_assoc()) {
                                                                            ?>
                                                                            <option class="text-sm" value="<?php echo $row1['nombre']; ?>"><?php echo $row1['nombre']; ?></option>
                                                                            <?php
                                                                        }
                                                                    }
                                                                    ?>
                                                                </select>
                                                            </div>
                                                            <div class="col-md-12 mb-3">
                                                                <label><strong>Monto</strong></label>
                                                                <input class="form-control" type="text" required="" name="monto" value="0">
                                                            </div>
                                                            <div class="col-md-12 mb-3">
                                                                <label><strong>Tercero destino</strong></label>
                                                                <select class="form-select"  required="" name="tercero_destino">                                           
                                                                    <option selected="" disabled="" value="">Seleccione</option>
                                                                    <?php
                                                                    $sql2 = "SELECT * FROM tercero";
                                                                    $query2 = $conn->query($sql2);
                                                                    if ($query2->num_rows > 0) {
                                                                        while ($row2 = $query2->fetch_assoc()) {
                                                                            ?>
                                                                            <option class="text-sm" value="<?php echo $row2['nombre']; ?>"><?php echo $row2['nombre']; ?></option>
                                                                            <?php
                                                                        }
                                                                    }
                                                                    ?>
                                                                </select>
                                                            </div>
                                                            <div class="col-md-12 mb-3">
                                                                <label><strong>Descripcion</strong></label>
                                                                <textarea class="form-control" type="text" required="" name="descripcion" value="0">Opcional</textarea>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="submit" class="btn btn-primary px-3 radius-30" >Guardar</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card">
                        <div class="card-body">
                            <h6 class="mb-0 text-uppercase">Cruce de cuentas</h6>
                            <hr/>
                            <div class="table-responsive rounded mt-3 bg-white p-2">
                                <table class="table align-middle mb-0" id="example2" style="width: 100%;">
                                    <thead>
                                        <tr class="text-white azul_bg ">
                                            <th class="text-center">Id</th>
                                            <th class="text-center">Fecha</th>
                                            <th class="text-center">Tercero origen</th>
                                            <th class="text-center">Monto</th>
                                            <th class="text-center">Tercero destino</th>
                                            <th class="text-center">Descripcion</th>
                                            <th class="text-center">Acciones</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $sql = "SELECT * FROM cruce_cuenta";
                                        $query = $conn->query($sql);
                                        if ($query->num_rows > 0) {
                                            while ($row = $query->fetch_assoc()) {
                                                ?>
                                                <tr>
                                                    <td class="text-center"><?php echo $row['id']; ?></td>
                                                    <td class="text-center"><?php echo $row['fecha']; ?></td>
                                                    <td class=""><strong><?php echo $row['nombre_tercero_origen']; ?></strong></td>
                                                    <td class="text-end"><?php echo number_format($row['monto'], 0, ',', '.'); ?></td>
                                                    <td class=""><strong><?php echo $row['nombre_tercero_destino']; ?></strong></td>
                                                    <td class="text-center"><?php echo $row['descripcion']; ?></td>
                                                    <td class="text-center">
                                                        <a  href="#editar"
                                                            data-bs-toggle="modal"
                                                            data-target="#editar"

                                                            data-id="<?php echo $row['id']; ?>"
                                                            data-fecha="<?php echo $row['fecha']; ?>"
                                                            data-tercero_origen="<?php echo $row['nombre_tercero_origen']; ?>"
                                                            data-monto="<?php echo $row['monto']; ?>"
                                                            data-tercero_destino="<?php echo $row['nombre_tercero_destino']; ?>"
                                                            data-descripcion="<?php echo $row['descripcion']; ?>">

                                                            <i class="far fa-edit"></i>
                                                        </a>

                                                    </td>
                                                </tr>
                                                <?php
                                            }
                                        }
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>    

                </div>
                <?php echo include '../general/footer.php'; ?>
            </div>
        </div>
        <!--end wrapper-->
        <?php echo include '../general/libreria-js.php'; ?>

        <div class="modal fade" id="editar" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-sm">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title card-heading" id="exampleModalLabel">Formulario | Editar cruce</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form class="" method="POST" action="script/cruce-editar.php">
                        <div class="modal-body ">

                            <input type="text" name="edit_id" id="edit_id" parsley-trigger="change" required
                                   class="form-control" >

                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <label><strong>Fecha</strong></label>
                                    <input class="form-control" type="date" required="" name="edit_fecha" id="edit_fecha">
                                </div>
                                <div class="col-md-12 mb-3">
                                    <label><strong>Tercero origen</strong></label>
                                    <select class="form-select"  required="" name="edit_tercero_origen" id="edit_tercero_origen">                                           
                                        <option selected="" disabled="" value="">Seleccione</option>
                                        <?php
                                        $sql1 = "SELECT * FROM tercero";
                                        $query1 = $conn->query($sql1);
                                        if ($query1->num_rows > 0) {
                                            while ($row1 = $query1->fetch_assoc()) {
                                                ?>
                                                <option class="text-sm" value="<?php echo $row1['nombre']; ?>"><?php echo $row1['nombre']; ?></option>
                                                <?php
                                            }
                                        }
                                        ?>
                                    </select>
                                </div>
                                <div class="col-md-12 mb-3">
                                    <label><strong>Monto</strong></label>
                                    <input class="form-control" type="text" required="" name="edit_monto" id="edit_monto" value="0">
                                </div>
                                <div class="col-md-12 mb-3">
                                    <label><strong>Tercero destino</strong></label>
                                    <select class="form-select"  required="" name="edit_tercero_destino" id="edit_tercero_destino">                                           
                                        <option selected="" disabled="" value="">Seleccione</option>
                                        <?php
                                        $sql2 = "SELECT * FROM tercero";
                                        $query2 = $conn->query($sql2);
                                        if ($query2->num_rows > 0) {
                                            while ($row2 = $query2->fetch_assoc()) {
                                                ?>
                                                <option class="text-sm" value="<?php echo $row2['nombre']; ?>"><?php echo $row2['nombre']; ?></option>
                                                <?php
                                            }
                                        }
                                        ?>
                                    </select>
                                </div>
                                <div class="col-md-12 mb-3">
                                    <label><strong>Descripcion</strong></label>
                                    <textarea class="form-control" type="text" required="" name="edit_descripcion" id="edit_descripcion" value="0"></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-secondary" name="eliminar" 
                                    onclick="if (!confirm('Seguro deseas eliminar este registro?')) {
                                                return false

                                            }">Eliminar</button>
                            <button type="submit" class="btn btn-info" name="editar" >Editar</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <script>
            // PASO DE PARAMETROS EDITAR

            $('#editar').on('show.bs.modal', function (event) {
                var button = $(event.relatedTarget) // Button that triggered the modal

                var id = button.data('id')
                var fecha = button.data('fecha')
                var tercero_origen = button.data('tercero_origen')
                var monto = button.data('monto')
                var tercero_destino = button.data('tercero_destino')
                var descripcion = button.data('descripcion')


                $('#edit_id').val(id)
                $('#edit_fecha').val(fecha)
                $('#edit_tercero_origen').val(tercero_origen)
                $('#edit_monto').val(monto)
                $('#edit_tercero_destino').val(tercero_destino)
                $('#edit_descripcion').val(descripcion)

            });

        </script>


        <script>
            //Tabla producto
            $(document).ready(function () {
                var table = $('#example2').DataTable({
                    lengthChange: false,
                    buttons: ['copy', 'excel', 'pdf', 'print'],
                    "order": false,
                });

                table.buttons().container()
                        .appendTo('#example2_wrapper .col-md-6:eq(0)');
            });

        </script>

    </body>
</html>